/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/


#ifndef __GENEZIP__DEFINES_H__
#define __GENEZIP__DEFINES_H__
/*!
  \def GENEZIP_LITERAL_VALUE_UPPER_BOUND
  \brief upper bound on gzip "literal" definition

  In canonical gzip, this value is 256 (literals are [0,255]; 
  end-of-block is 256).  A value of 2002 will handle 3-decimal
  precision dosages (and probabilities); 1002 will handle 
  3-decimal precision probabilities only.
 */
#define GENEZIP_LITERAL_VALUE_UPPER_BOUND 2002
/*!
  \def GENEZIP_LENGTH_ERROR_UNSIGNED_CODE
  \brief an error code for stored lengths
 */
#define GENEZIP_LENGTH_ERROR_UNSIGNED_CODE static_cast<unsigned>(-1)
/*!
  \def GENEZIP_MAX_OFFSET_POINTER
  \brief max distance from leading edge at which a reverse reference can start.
 */
#define GENEZIP_MAX_OFFSET_POINTER 32768
/*!
  \def GENEZIP_GENERAL_INPUT_HASH_MAX_VALUE
  \brief upper bound of values generated by this hash.  Used to mod 
  output of hash function.

  Note that this bound will generate a perfect hash for probabilities,
  but not for dosages.  This compromise is made for the sake of memory,
  which may not actually be needed.
 */
#define GENEZIP_GENERAL_INPUT_HASH_MAX_VALUE 1002001
/*!
  \def GENEZIP_DEFAULT_BIN_SIZE_LIMIT
  \brief number of vectors to be stored in a single bin/block, for compression
 */
#define GENEZIP_DEFAULT_BIN_SIZE_LIMIT 1000

#define GENEZIP_SIMULTANEOUS_ALLOC_SIZE (GENEZIP_MAX_OFFSET_POINTER<<1)
#endif //__DEFINES_H__
