// -*- C++ -*-

/* 
 * Gnome Crystal
 * prefs.cc 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "prefs.h"
#include "globals.h"
#include "application.h"

guint PrintResolution = 300;

//signals functions
static void on_tab_position(GtkWidget *widget, gcPrefsDlg * dialog)
{
	dialog->TabPositionSelect(widget);
}
	

static void on_print_resolution(GtkWidget *widget, gcPrefsDlg * dialog)
{
	dialog->PrintResolutionSelect(widget);
}

gcPrefsDlg::gcPrefsDlg(): gcDialog(DATADIR"/gcrystal/glade/prefs.glade", "prefs")
{
	TabsMenu = (GtkOptionMenu*) glade_xml_get_widget(xml, "tabpos");
	GtkMenu* menu = GTK_MENU(TabsMenu->menu);
	GList* list = menu->menu_shell.children;
	while (list)
	{
		g_signal_connect(G_OBJECT(list->data), "activate", GTK_SIGNAL_FUNC(on_tab_position), this);
		list = g_list_next(list);
	}
	gtk_option_menu_set_history(TabsMenu, TabPos);
	PrintResMenu = (GtkOptionMenu*) glade_xml_get_widget(xml, "printres");
	menu = GTK_MENU(PrintResMenu->menu);
	list = menu->menu_shell.children;
	while (list)
	{
		g_signal_connect(G_OBJECT(list->data), "activate", GTK_SIGNAL_FUNC(on_print_resolution), this);
		list = g_list_next(list);
	}
	PrintResBtn = (GtkSpinButton*) glade_xml_get_widget(xml, "printresbtn");
	m_nPrintRes = PrintResolution;
	m_nTabPos = TabPos;
	switch (m_nPrintRes)
	{
		case 300: m_nPrintIndex = 0; break;
		case 360: m_nPrintIndex = 1; break;
		case 600: m_nPrintIndex = 2; break;
		case 720: m_nPrintIndex = 3; break;
		case 1200: m_nPrintIndex = 4; break;
		case 1440: m_nPrintIndex = 5; break;
		case 2400: m_nPrintIndex = 6; break;
		case 2880: m_nPrintIndex = 7; break;
		default: m_nPrintIndex = 8; gtk_spin_button_set_value(PrintResBtn, m_nPrintRes); break;
	}
	gtk_option_menu_set_history(PrintResMenu, m_nPrintIndex);
	UpdatePrinting();
	FoVBtn = GTK_SPIN_BUTTON(glade_xml_get_widget(xml, "fov"));
	gtk_spin_button_set_value(FoVBtn, FoV);
	PsiEnt = (GtkEntry*) glade_xml_get_widget(xml, "psi");
	ThetaEnt = (GtkEntry*) glade_xml_get_widget(xml, "theta");
	PhiEnt = (GtkEntry*) glade_xml_get_widget(xml, "phi");
	char m_buf[32];
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", Psi);
	gtk_entry_set_text(PsiEnt, m_buf);
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", Theta);
	gtk_entry_set_text(ThetaEnt, m_buf);
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", Phi);
	gtk_entry_set_text(PhiEnt, m_buf);
	BackgroundBtn = (GnomeColorPicker*) glade_xml_get_widget(xml, "color");
	gnome_color_picker_set_d(BackgroundBtn, Red, Green, Blue, 1.0);
	gtk_widget_show_all(GTK_WIDGET(dialog));
}

gcPrefsDlg::~gcPrefsDlg()
{
}

bool gcPrefsDlg::Apply()
{
	double x0, x1, x2;
	if (!GetNumber(PsiEnt, &x0, gccMinEqMax, -180, 180)) return false;
	if (!GetNumber(ThetaEnt, &x1, gccMinEqMaxEq, 0, 180)) return false;
	if (!GetNumber(PhiEnt, &x2, gccMinEqMax, -180, 180)) return false;
	TabPos = m_nTabPos;
	std::list<gcApplication*>::iterator i;
	for (i = Apps.begin(); i != Apps.end(); i++) (*i)->UpdateConfig();
	PrintResolution = m_nPrintRes;
	Psi = x0;
	Theta= x1;
	Phi = x2;
	FoV = gtk_spin_button_get_value_as_int(FoVBtn);
	gnome_color_picker_get_d(BackgroundBtn, &Red, &Green, &Blue, &x0);
	gconf_client_set_int(conf_client, "/apps/gcrystal/general/tab_pos", TabPos, NULL);
	gconf_client_set_int(conf_client, "/apps/gcrystal/printing/resolution", PrintResolution, NULL);
	gconf_client_set_int(conf_client, "/apps/gcrystal/views/fov", FoV, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/psi", Psi, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/theta", Theta, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/phi", Phi, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/red", Red, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/green", Green, NULL);
	gconf_client_set_float(conf_client, "/apps/gcrystal/views/blue", Blue, NULL);
	return true;
}

void gcPrefsDlg::PrintResolutionSelect(GtkWidget* widget)
{
	m_nPrintIndex = GetOptionMenuIndex(PrintResMenu, widget);
	m_nPrintRes = gtk_spin_button_get_value_as_int(PrintResBtn);
	UpdatePrinting();
}

void gcPrefsDlg::TabPositionSelect(GtkWidget* widget)
{
	m_nTabPos = GetOptionMenuIndex(TabsMenu, widget);
}

void gcPrefsDlg::UpdatePrinting()
{
	switch (m_nPrintIndex)
	{
		case 0: m_nPrintRes = 300; break;
		case 1: m_nPrintRes = 360; break;
		case 2: m_nPrintRes = 600; break;
		case 3: m_nPrintRes = 720; break;
		case 4: m_nPrintRes = 1200; break;
		case 5: m_nPrintRes = 1440; break;
		case 6: m_nPrintRes = 2400; break;
		case 7: m_nPrintRes = 2880; break;
	}
	gtk_spin_button_set_value(PrintResBtn, m_nPrintRes);
	gtk_widget_set_sensitive(GTK_WIDGET(PrintResBtn), (m_nPrintIndex < 8) ? false : true);
}
