// -*- C++ -*-

/* 
 * Gnome Crystal
 * latticedlg.h 
 *
 * Copyright (C) 2000-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCRYSTAL_LATTICEDLG_H
#define GCRYSTAL_LATTICEDLG_H

#include <string>
#include <map>
#include "document.h"
#include "atom.h"
#include "dialog.h"

class gcLatticeDlg: public gcDialog
{
public:
	gcLatticeDlg(gcDocument* pDoc, unsigned nPage);
	virtual ~gcLatticeDlg();
	
	virtual bool Apply();
	void AtomAdd();
	void AtomDelete();
	void AtomModify();
	void AtomDeleteAll();
	void AtomSelect();
	void BondAdd();
	void BondDelete();
	void BondModify();
	void BondDeleteAll();
	void BondSelect();
	void BondTypeChanged();
	void CleavageAdd();
	void CleavageDelete();
	void CleavageModify();
	void CleavageDeleteAll();
	void CleavageSelect();
	void LatticeSelect(GtkWidget *widget);
	void OnElement();
	void SetElement(int Z);
	void OnCloseChild() {mendeleiev = NULL;}
	
private:
	gcAtom* GetNewAtom();
	gcBond* GetNewBond();
	gcCleavage* GetNewCleavage();
	char* GetListText(GtkList* plist, unsigned* pos = NULL);
	void UpdateCell();
	
	gcAtomList* m_pAtoms;
	gcBondList* m_pBonds;
	gcCleavageList* m_pCleavages;
	std::map<std::string,gcAtom*>m_mAtoms;
	std::map<std::string,gcBond*>m_mBonds;
	std::map<std::string,gcCleavage*>m_mCleavages;
	gcDocument* m_pDoc;
	
	gcAtom* m_pAtom;
	gcBond* m_pBond;
	gcCleavage* m_pCleavage;
	double x, x1, y, y1, z, z1, r, red, green, blue, alpha;
	int m_Z;//atomic number
	gcBondType m_BondType;
	
	char m_buf[64];
	gcLattices m_Lattice;
	gdouble m_a, m_b, m_c, m_alpha, m_beta, m_gamma;
	
	void* mendeleiev;
	GtkEntry *AtomX, *AtomY, *AtomZ, *AtomR, *MaxX, *MinX, *MaxY, *MinY, *MaxZ, *MinZ;
	GtkEntry *BondX1, *BondY1, *BondZ1, *BondX2, *BondY2, *BondZ2, *BondR;
	GtkToggleButton *Btn0, *Btn1, *Btn2, *Btn3, *Btn4, *FixedBtn;
	GtkSpinButton *Btnh, *Btnk, *Btnl, *Btnn;
	GtkEntry *A, *B, *C, *Alpha, *Beta, *Gamma;
	GnomeColorPicker *AtomColor, *BondColor;
	GtkList *AtomList, *BondList, *CleavageList;
	GtkButton *AtomDeleteAllBtn, *AtomDeleteBtn, *AtomModifyBtn, *ElementBtn,
				*BondDeleteAllBtn, *BondDeleteBtn, *BondModifyBtn,
				*CleavageDeleteAllBtn, *CleavageDeleteBtn, *CleavageModifyBtn;
	GtkOptionMenu *LatticeMenu;
};

#endif // GCRYSTAL_LATTICEDLG_H
