// -*- C++ -*-

/* 
 * Gnome Crystal
 * gcrystal-bonobo.cc 
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
#include "config.h"
#include "globals.h"
#include "gcrystal-bonobo.h"
#include "view.h"
#include "view-settings.h"
#include "filesel.h"

#include <bonobo/bonobo-print.h>
#ifdef USING_BONOBO

static void on_load(BonoboPersistStream *ps, Bonobo_Stream stream, Bonobo_Persist_ContentType type, embeddable_data_t *data, CORBA_Environment  *ev)
{
	CORBA_long l = bonobo_stream_client_get_length (stream, ev);
	Bonobo_Stream_iobuf*  buffer;
	Bonobo_Stream_read(stream, l, &buffer, ev);
	char buf[l+1];
	memcpy(buf, buffer->_buffer, l);
	buf[l] = 0;
	xmlDocPtr xml = xmlParseMemory(buf, l);
	CORBA_free (buffer);
	if (xml) data->pDoc->ParseXMLTree(xml);
}

static void on_save(BonoboPersistStream *ps, Bonobo_Stream stream, Bonobo_Persist_ContentType type, embeddable_data_t *data, CORBA_Environment  *ev)
{
	xmlDocPtr xml = data->pDoc->BuildXMLTree();
	if (xml)
	{
		char* tmp;
		int size;
		xmlDocDumpMemory(xml, (xmlChar**)(&tmp), &size);
		if (tmp)
		{
			bonobo_stream_client_write (stream, tmp, size, ev);
			xmlFree((xmlChar*)(tmp));
		}
		xmlFreeDoc(xml);
	}
}

static void gcrystal_object_print(GnomePrintContext *ctx, double width, double height, const Bonobo_PrintScissor *scissor, embeddable_data_t *data)
{
	gcView* pView =  data->pDoc->GetView();
	pView->Print(ctx, width, height);
}


static void on_embeddable_exception(BonoboEmbeddable *embeddable, CORBA_Object object, CORBA_Environment *ev, gpointer data)
{
	bonobo_object_unref(BONOBO_OBJECT(embeddable));
}

static void on_embeddable_destroy(BonoboEmbeddable *embeddable, embeddable_data_t *data)
{
	RemoveDocument(data->pDoc);
	delete data;
}

static void on_view_exception(BonoboView *view, CORBA_Object object, CORBA_Environment *ev, gpointer data)
{
	bonobo_object_unref(BONOBO_OBJECT(view));
}

static void on_view_destroy(BonoboView *view, view_data_t *data)
{
	gtk_widget_destroy(data->widget);
	delete data;
}

static void do_load(const gchar* filename, gcView *pView)
{
	gcDocument* pDoc = pView->GetDocument();
	if (pDoc) pDoc->Load(filename);
}

static void on_lattice(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	gcDocument* pDoc = data->pView->GetDocument();
	if (pDoc) pDoc->Define();
}

static void on_atoms(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	gcDocument* pDoc = data->pView->GetDocument();
	if (pDoc) pDoc->Define(1);
}

static void on_bonds(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	gcDocument* pDoc = data->pView->GetDocument();
	if (pDoc) pDoc->Define(2);
}

static void on_size(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	gcDocument* pDoc = data->pView->GetDocument();
	if (pDoc) pDoc->Define(3);
}

static void on_cleavages(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	gcDocument* pDoc = data->pView->GetDocument();
	if (pDoc) pDoc->Define(4);
}

static void on_view_settings(BonoboUIComponent *uic, view_data_t* data, const char *cname)
{
	if (!data->pView) return;
	gcViewSettingsDlg* pDlg = new gcViewSettingsDlg(data->pView);
}

static void on_view_activate(BonoboView *view, gboolean activate, view_data_t *data)
{
	bonobo_view_activate_notify(view, activate);
	BonoboUIComponent *uic = bonobo_view_get_ui_component(data->view);
	if (activate)
	{
		Bonobo_UIContainer remote_uic = bonobo_view_get_remote_ui_container(data->view);

		if (remote_uic == CORBA_OBJECT_NIL)
		{
			g_warning(_("Can't get remote UIContainer"));
			return;
		}
		bonobo_ui_component_set_container(uic, remote_uic);

		static BonoboUIVerb my_ui_verbs[] = {
			BONOBO_UI_VERB ("Lattice", (void (*)(BonoboUIComponent*, void*, const char*)) on_lattice),
			BONOBO_UI_VERB ("Atoms", (void (*)(BonoboUIComponent*, void*, const char*)) on_atoms),
			BONOBO_UI_VERB ("Bonds", (void (*)(BonoboUIComponent*, void*, const char*)) on_bonds),
			BONOBO_UI_VERB ("Size", (void (*)(BonoboUIComponent*, void*, const char*)) on_size),
			BONOBO_UI_VERB ("Cleavages", (void (*)(BonoboUIComponent*, void*, const char*)) on_cleavages),
			BONOBO_UI_VERB ("ViewSettings", (void (*)(BonoboUIComponent*, void*, const char*)) on_view_settings),
			BONOBO_UI_VERB_END
		};

		bonobo_ui_util_set_ui (uic, PREFIX, "gcrystal.xml", "gcrystal");
		bonobo_ui_component_add_verb_list_with_data (uic, my_ui_verbs, data);
		bonobo_ui_component_thaw(uic, NULL);
	}
	else
	{
		bonobo_ui_component_unset_container(uic);
	}
}

static BonoboView * view_factory(BonoboEmbeddable *embeddable, const Bonobo_ViewFrame view_frame, embeddable_data_t *data)
{
	view_data_t *view_data = new view_data_t;
	view_data->data = data;
	view_data->pView = data->pDoc->GetView();
	view_data->widget = view_data->pView->CreateNewWidget();
	GtkWidget *vbox = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox), view_data->widget, TRUE, TRUE, 0);
	gtk_widget_show_all(vbox);
	BonoboView *view = bonobo_view_new(vbox);
	view_data->view = view;
	gtk_signal_connect(GTK_OBJECT(view), "activate", GTK_SIGNAL_FUNC(on_view_activate), view_data);
	gtk_signal_connect(GTK_OBJECT(view), "system_exception", GTK_SIGNAL_FUNC(on_view_exception), view_data);
	gtk_signal_connect(GTK_OBJECT(view), "destroy", GTK_SIGNAL_FUNC(on_view_destroy), view_data);
	return view;
}

BonoboObject * embeddable_factory(BonoboGenericFactory * fact, void* data)
{
	embeddable_data_t *embed_data;
	embed_data = new embeddable_data_t();
	if (embed_data == NULL) return NULL;
	
	embed_data->pDoc = GetNewDocument();
	embed_data->embeddable = bonobo_embeddable_new(BONOBO_VIEW_FACTORY(view_factory), embed_data);
	if (embed_data->embeddable == NULL) {RemoveDocument(embed_data->pDoc); delete embed_data; return NULL;}
	BonoboObject* print = BONOBO_OBJECT (bonobo_print_new ((void (*)(GnomePrintContext*, double, double, const Bonobo_PrintScissor*, void*)) gcrystal_object_print, embed_data));
	if (print) bonobo_object_add_interface (BONOBO_OBJECT (embed_data->embeddable), print);
	BonoboPersistStream *ps =  bonobo_persist_stream_new (
				(void (*)(BonoboPersistStream*, CORBA_Object_struct*, CORBA_char*, void*,    CORBA_Environment*)) on_load,
				(void (*)(BonoboPersistStream*, CORBA_Object_struct*, CORBA_char*, void*,    CORBA_Environment*)) on_save,
				NULL, NULL, embed_data);
	if (ps)
	{
		bonobo_object_add_interface (BONOBO_OBJECT (embed_data->embeddable), BONOBO_OBJECT(ps));
		embed_data->pDoc->SetBonoboStream(ps);
	}
	gtk_signal_connect (GTK_OBJECT (embed_data->embeddable), "system_exception", GTK_SIGNAL_FUNC (on_embeddable_exception), embed_data);
	gtk_signal_connect (GTK_OBJECT (embed_data->embeddable), "destroy", GTK_SIGNAL_FUNC (on_embeddable_destroy), embed_data);
	return BONOBO_OBJECT(embed_data->embeddable);
}
#endif
