// -*- C++ -*-

/* 
 * Gnome Crystal
 * dialog.h 
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "dialog.h"

static void on_OK(GtkWidget *widget, gcDialog* dialog)
{
	dialog->Apply();
	dialog->Destroy();
}

static void on_apply(GtkWidget *widget, gcDialog* dialog)
{
	dialog->Apply();
}

static void on_cancel(GtkWidget *widget, gcDialog* dialog)
{
	dialog->Destroy();
}
	
static bool on_destroy(GtkWidget *widget, gcDialog* dialog)
{
	delete dialog;
	return true;
}

static void on_help(GtkWidget* widget, gcDialog* dialog)
{
	dialog->Help();
}

gcDialog::gcDialog(const char* filename, const char* windowname, const char* helpfile)
{
	xml =  glade_xml_new(filename, windowname);
	if (xml)  glade_xml_signal_autoconnect (xml);
	dialog = GTK_WINDOW(glade_xml_get_widget(xml, windowname));
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(on_destroy), this);
	GtkWidget* button = glade_xml_get_widget(xml, "OK");
	if (button) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_OK), this);
	button = glade_xml_get_widget(xml, "apply");
	if (button) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_apply), this);
	button = glade_xml_get_widget(xml, "cancel");
	if (button) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_cancel), this);
	button = glade_xml_get_widget(xml, "help");
	if (button) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_help), this);
	if (helpfile) m_HelpFile = g_strdup(helpfile);
	else m_HelpFile = NULL;
	notebook = (GtkNotebook*)glade_xml_get_widget(xml, "notebook");
}

gcDialog::~gcDialog()
{
	if (m_HelpFile) g_free(m_HelpFile);
}

void gcDialog::Destroy()
{
	gtk_widget_destroy(GTK_WIDGET(dialog));
}

bool gcDialog::Apply() {}

void gcDialog::Help()
{
	gchar* tag = NULL;
	if (notebook)
	{
		int i = gtk_notebook_get_current_page(notebook);
		GtkWidget* w = gtk_notebook_get_nth_page(notebook, i);
		tag = gtk_widget_get_name(w);
		g_strup(tag);
	}
	gchar* helpfile = (m_HelpFile) ? gnome_help_file_find_file("gcrystal", m_HelpFile) : gnome_help_file_find_file("gcrystal", "index.html");
	if (helpfile != NULL)
	{
		gchar* url = (tag) ? g_strconcat("ghelp:", helpfile, "#", tag, NULL) : g_strconcat("ghelp:", helpfile, NULL);
		gnome_help_goto(NULL, url);
		g_free(url);
		g_free(helpfile);
	}
	else
	{
		gchar *str = g_strdup_printf(_("Couldn't find help file:\n%s"), helpfile);
		gnome_error_dialog(str);
		g_free(str);
	}
}

bool gcDialog::GetNumber(GtkEntry *Entry, double *x, gcCheckType c, double min, double max)
{
	gchar* text = gtk_entry_get_text (Entry);
	char *end;
	*x = strtod(text, &end);
	if (end != text + strlen(text))
	{
		gtk_window_set_focus(GTK_WINDOW(dialog), GTK_WIDGET(Entry));
		GnomeDialog* box = (GnomeDialog*)gnome_error_dialog_parented(_("Type a number"), GTK_WINDOW(dialog));
		gnome_dialog_run(box);
		return false;
	}
	switch (c)
	{
	case gccMinEqMax:
		if ((*x < min) || (*x >= max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GnomeDialog* box = (GnomeDialog*)gnome_error_dialog_parented(m_buf, GTK_WINDOW(dialog));
			gnome_dialog_run(box);
			return false;
		}
		break;
	case gccMinEqMaxEq:
		if ((*x < min) || (*x > max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GnomeDialog* box = (GnomeDialog*)gnome_error_dialog_parented(m_buf, GTK_WINDOW(dialog));
			gnome_dialog_run(box);
			return false;
		}
		break;
	case gccMinMax:
		if ((*x <= min) || (*x >= max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GnomeDialog* box = (GnomeDialog*)gnome_error_dialog_parented(m_buf, GTK_WINDOW(dialog));
			gnome_dialog_run(box);
			return false;
		}
		break;
	case gccMin:
		if (*x < min)
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number greater than %g"), min);
			GnomeDialog* box = (GnomeDialog*)gnome_error_dialog_parented(m_buf, GTK_WINDOW(dialog));
			gnome_dialog_run(box);
			return false;
		}
		break;
	}
	return true;
}

guint gcDialog::GetOptionMenuIndex(GtkOptionMenu* optionmenu, GtkWidget* widget)
{
	GtkMenu* menu = GTK_MENU(optionmenu->menu);
	GList* list = menu->menu_shell.children;
	int i = 0;
	while (list)
	{
		if (widget == GTK_WIDGET(list->data)) break;
		list = g_list_next(list);
		i++;
	}
	if (!list) //that should not happen!
	{
		gtk_option_menu_set_history(optionmenu, 0);
		return 0;
	}
	return i;
}
