/* gclip_select.c generated by valac 0.10.4, the Vala compiler
 * generated from gclip_select.vala, do not modify */

/*
Copyright 2011 Li-Cheng (Andy) Tai
                      atai@atai.org
                      
gclip_select is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

gclip_select is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
gclip_select. If not, see http://www.gnu.org/licenses/.


*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <time.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block3Data Block3Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _Block1Data {
	int _ref_count_;
	GtkListStore* list_model;
	GtkTreeSelection* selection;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gint WAIT_TIME;
};

struct _Block2Data {
	int _ref_count_;
	GtkScrolledWindow* list_view;
	GtkTreeView* list_box;
	char* content;
};


extern gboolean self_clip_set;
gboolean self_clip_set = FALSE;
extern gboolean new_insert;
gboolean new_insert = FALSE;
extern GtkClipboard* clip;
GtkClipboard* clip = NULL;
extern guint32 selection_time;
guint32 selection_time = (guint32) 0;
extern GeeHashMap* content_table;
GeeHashMap* content_table = NULL;
extern GtkButton* delete_button;
GtkButton* delete_button = NULL;
extern GtkButton* delete_all_button;
GtkButton* delete_all_button = NULL;

void setup_list_box (GtkTreeView* list_box);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void add_entry_to_list_box (GtkTreeView* list_box, const char* content);
void delete_current_selection (GtkTreeView* list_box);
static gboolean _gtk_tree_iter_equal (const GtkTreeIter* s1, const GtkTreeIter* s2);
void delete_all_selection (GtkTreeView* list_box);
gint _vala_main (char** args, int args_length1);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static void _lambda1_ (Block2Data* _data2_);
static void __lambda1__gtk_button_released (GtkButton* _sender, gpointer self);
static void _lambda2_ (Block2Data* _data2_);
static void __lambda2__gtk_button_released (GtkButton* _sender, gpointer self);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
static void _lambda3_ (GdkEvent* e, Block2Data* _data2_);
static gboolean _lambda4_ (Block3Data* _data3_);
static gboolean __lambda4__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void __lambda3__gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self);
static void _lambda5_ (GdkRectangle* rect, Block2Data* _data2_);
static void __lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 52 "gclip_select.vala"
static void _lambda0_ (Block1Data* _data1_) {
#line 113 "gclip_select.c"
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	char* content;
	GtkTreeModel* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_;
	model = NULL;
	content = NULL;
#line 57 "gclip_select.vala"
	if ((_tmp1_ = gtk_tree_selection_get_selected (_data1_->selection, &_tmp0_, &iter), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_)) {
#line 59 "gclip_select.vala"
		gtk_tree_model_get ((GtkTreeModel*) _data1_->list_model, &iter, 0, &content, -1, -1);
#line 61 "gclip_select.vala"
		if (!new_insert) {
#line 63 "gclip_select.vala"
			gtk_clipboard_set_text (clip, content, -1);
#line 64 "gclip_select.vala"
			self_clip_set = TRUE;
#line 132 "gclip_select.c"
		}
#line 67 "gclip_select.vala"
		gtk_widget_set_sensitive ((GtkWidget*) delete_button, TRUE);
#line 136 "gclip_select.c"
	} else {
#line 71 "gclip_select.vala"
		gtk_widget_set_sensitive ((GtkWidget*) delete_button, FALSE);
#line 140 "gclip_select.c"
	}
	_g_free0 (content);
	_g_object_unref0 (model);
}


#line 52 "gclip_select.vala"
static void __lambda0__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 149 "gclip_select.c"
	_lambda0_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->selection);
		_g_object_unref0 (_data1_->list_model);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 39 "gclip_select.vala"
void setup_list_box (GtkTreeView* list_box) {
#line 171 "gclip_select.c"
	Block1Data* _data1_;
	GtkCellRendererText* text_renderer;
#line 39 "gclip_select.vala"
	g_return_if_fail (list_box != NULL);
#line 176 "gclip_select.c"
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->list_model = gtk_list_store_new (1, G_TYPE_STRING);
#line 42 "gclip_select.vala"
	gtk_tree_view_set_rules_hint (list_box, TRUE);
#line 43 "gclip_select.vala"
	gtk_tree_view_set_model (list_box, (GtkTreeModel*) _data1_->list_model);
#line 44 "gclip_select.vala"
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
#line 45 "gclip_select.vala"
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
#line 46 "gclip_select.vala"
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
#line 48 "gclip_select.vala"
	gtk_tree_view_insert_column_with_attributes (list_box, -1, "Clip content Selector", (GtkCellRenderer*) text_renderer, "text", 0, NULL);
#line 49 "gclip_select.vala"
	gtk_tree_view_set_headers_visible (list_box, FALSE);
#line 194 "gclip_select.c"
	_data1_->selection = _g_object_ref0 (gtk_tree_view_get_selection (list_box));
#line 52 "gclip_select.vala"
	g_signal_connect_data (_data1_->selection, "changed", (GCallback) __lambda0__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 198 "gclip_select.c"
	_g_object_unref0 (text_renderer);
	block1_data_unref (_data1_);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1194 "glib-2.0.vapi"
	return result;
#line 210 "gclip_select.c"
}


#line 79 "gclip_select.vala"
void add_entry_to_list_box (GtkTreeView* list_box, const char* content) {
#line 216 "gclip_select.c"
	GtkTreeIter iter = {0};
	char* cksum;
	GtkTreeSelection* selection;
#line 79 "gclip_select.vala"
	g_return_if_fail (list_box != NULL);
#line 79 "gclip_select.vala"
	g_return_if_fail (content != NULL);
#line 82 "gclip_select.vala"
	cksum = g_compute_checksum_for_string (G_CHECKSUM_SHA256, content, -1);
#line 83 "gclip_select.vala"
	if (string_get_length (content) == 0) {
#line 228 "gclip_select.c"
		_g_free0 (cksum);
#line 84 "gclip_select.vala"
		return;
#line 232 "gclip_select.c"
	}
#line 85 "gclip_select.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) content_table, cksum)) {
#line 236 "gclip_select.c"
		GtkTreeIter* _tmp0_;
#line 87 "gclip_select.vala"
		iter = *(_tmp0_ = (GtkTreeIter*) gee_abstract_map_get ((GeeAbstractMap*) content_table, cksum));
#line 240 "gclip_select.c"
		_g_free0 (_tmp0_);
	} else {
		GtkListStore* list_model;
#line 92 "gclip_select.vala"
		list_model = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_view_get_model (list_box)));
#line 93 "gclip_select.vala"
		gtk_list_store_append (list_model, &iter);
#line 95 "gclip_select.vala"
		gtk_list_store_set (list_model, &iter, 0, content, -1);
#line 96 "gclip_select.vala"
		gee_abstract_map_set ((GeeAbstractMap*) content_table, cksum, &iter);
#line 97 "gclip_select.vala"
		new_insert = TRUE;
#line 254 "gclip_select.c"
		_g_object_unref0 (list_model);
	}
#line 99 "gclip_select.vala"
	selection = _g_object_ref0 (gtk_tree_view_get_selection (list_box));
#line 100 "gclip_select.vala"
	gtk_tree_selection_select_iter (selection, &iter);
#line 102 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_button, TRUE);
#line 103 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_all_button, TRUE);
#line 265 "gclip_select.c"
	_g_object_unref0 (selection);
	_g_free0 (cksum);
}


static gboolean _gtk_tree_iter_equal (const GtkTreeIter* s1, const GtkTreeIter* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->stamp != s2->stamp) {
		return FALSE;
	}
	if (s1->user_data != s2->user_data) {
		return FALSE;
	}
	if (s1->user_data2 != s2->user_data2) {
		return FALSE;
	}
	if (s1->user_data3 != s2->user_data3) {
		return FALSE;
	}
	return TRUE;
}


#line 108 "gclip_select.vala"
void delete_current_selection (GtkTreeView* list_box) {
#line 299 "gclip_select.c"
	GtkTreeSelection* selection;
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	GtkTreeModel* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp6_ = NULL;
	gboolean _tmp7_;
	GtkTreeModel* _tmp8_;
#line 108 "gclip_select.vala"
	g_return_if_fail (list_box != NULL);
#line 110 "gclip_select.vala"
	selection = _g_object_ref0 (gtk_tree_view_get_selection (list_box));
#line 313 "gclip_select.c"
	model = NULL;
#line 113 "gclip_select.vala"
	if ((_tmp1_ = gtk_tree_selection_get_selected (selection, &_tmp0_, &iter), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_)) {
#line 317 "gclip_select.c"
		GeeMapIterator* it;
		GtkListStore* list_model;
#line 115 "gclip_select.vala"
		it = gee_abstract_map_map_iterator ((GeeAbstractMap*) content_table);
#line 116 "gclip_select.vala"
		list_model = _g_object_ref0 (GTK_LIST_STORE (model));
#line 117 "gclip_select.vala"
		if (gee_map_iterator_first (it)) {
#line 118 "gclip_select.vala"
			while (TRUE) {
#line 328 "gclip_select.c"
				GtkTreeIter* _tmp3_;
				gboolean _tmp4_;
#line 118 "gclip_select.vala"
				if (!gee_map_iterator_has_next (it)) {
#line 118 "gclip_select.vala"
					break;
#line 335 "gclip_select.c"
				}
#line 120 "gclip_select.vala"
				if ((_tmp4_ = _gtk_tree_iter_equal (_tmp3_ = (GtkTreeIter*) gee_map_iterator_get_value (it), &iter) == TRUE, _g_free0 (_tmp3_), _tmp4_)) {
#line 339 "gclip_select.c"
					char* _tmp5_;
#line 122 "gclip_select.vala"
					gee_abstract_map_unset ((GeeAbstractMap*) content_table, _tmp5_ = (char*) gee_map_iterator_get_key (it), NULL);
#line 343 "gclip_select.c"
					_g_free0 (_tmp5_);
#line 123 "gclip_select.vala"
					break;
#line 347 "gclip_select.c"
				}
#line 125 "gclip_select.vala"
				gee_map_iterator_next (it);
#line 351 "gclip_select.c"
			}
		}
#line 127 "gclip_select.vala"
		gtk_tree_selection_unselect_iter (selection, &iter);
#line 128 "gclip_select.vala"
		gtk_list_store_remove (list_model, &iter);
#line 129 "gclip_select.vala"
		if (list_model->length == 0) {
#line 130 "gclip_select.vala"
			gtk_widget_set_sensitive ((GtkWidget*) delete_all_button, FALSE);
#line 362 "gclip_select.c"
		}
		_g_object_unref0 (list_model);
		_g_object_unref0 (it);
	}
#line 132 "gclip_select.vala"
	if (!(_tmp7_ = gtk_tree_selection_get_selected (selection, &_tmp6_, &iter), model = (_tmp8_ = _g_object_ref0 (_tmp6_), _g_object_unref0 (model), _tmp8_), _tmp7_)) {
#line 134 "gclip_select.vala"
		gtk_widget_set_sensitive ((GtkWidget*) delete_button, FALSE);
#line 371 "gclip_select.c"
	}
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


#line 139 "gclip_select.vala"
void delete_all_selection (GtkTreeView* list_box) {
#line 380 "gclip_select.c"
	GtkListStore* list_model;
	GtkTreeSelection* selection;
#line 139 "gclip_select.vala"
	g_return_if_fail (list_box != NULL);
#line 141 "gclip_select.vala"
	list_model = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_view_get_model (list_box)));
#line 142 "gclip_select.vala"
	selection = _g_object_ref0 (gtk_tree_view_get_selection (list_box));
#line 143 "gclip_select.vala"
	gtk_tree_selection_unselect_all (selection);
#line 144 "gclip_select.vala"
	gtk_list_store_clear (list_model);
#line 145 "gclip_select.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) content_table);
#line 146 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_button, FALSE);
#line 147 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_all_button, FALSE);
#line 399 "gclip_select.c"
	_g_object_unref0 (selection);
	_g_object_unref0 (list_model);
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


#line 177 "gclip_select.vala"
static void _lambda1_ (Block2Data* _data2_) {
#line 179 "gclip_select.vala"
	delete_current_selection (_data2_->list_box);
#line 417 "gclip_select.c"
}


#line 177 "gclip_select.vala"
static void __lambda1__gtk_button_released (GtkButton* _sender, gpointer self) {
#line 423 "gclip_select.c"
	_lambda1_ (self);
}


#line 183 "gclip_select.vala"
static void _lambda2_ (Block2Data* _data2_) {
#line 185 "gclip_select.vala"
	delete_all_selection (_data2_->list_box);
#line 432 "gclip_select.c"
}


#line 183 "gclip_select.vala"
static void __lambda2__gtk_button_released (GtkButton* _sender, gpointer self) {
#line 438 "gclip_select.c"
	_lambda2_ (self);
}


#line 7766 "gtk+-2.0.vapi"
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
#line 445 "gclip_select.c"
	gtk_main_quit ();
}


#line 211 "gclip_select.vala"
static gboolean _lambda4_ (Block3Data* _data3_) {
#line 452 "gclip_select.c"
	Block2Data* _data2_;
	gboolean result = FALSE;
	_data2_ = _data3_->_data2_;
#line 213 "gclip_select.vala"
	if ((time (NULL) - selection_time) >= _data3_->WAIT_TIME) {
#line 215 "gclip_select.vala"
		if (!self_clip_set) {
#line 460 "gclip_select.c"
			char* _tmp0_;
#line 217 "gclip_select.vala"
			_data2_->content = (_tmp0_ = g_strdup (gtk_clipboard_wait_for_text (clip)), _g_free0 (_data2_->content), _tmp0_);
#line 218 "gclip_select.vala"
			add_entry_to_list_box (_data2_->list_box, _data2_->content);
#line 466 "gclip_select.c"
		} else {
#line 221 "gclip_select.vala"
			self_clip_set = FALSE;
#line 470 "gclip_select.c"
		}
	}
	result = FALSE;
#line 223 "gclip_select.vala"
	return result;
#line 476 "gclip_select.c"
}


#line 211 "gclip_select.vala"
static gboolean __lambda4__gsource_func (gpointer self) {
#line 482 "gclip_select.c"
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 206 "gclip_select.vala"
static void _lambda3_ (GdkEvent* e, Block2Data* _data2_) {
#line 505 "gclip_select.c"
	Block3Data* _data3_;
	GSource* time_out;
#line 206 "gclip_select.vala"
	g_return_if_fail (e != NULL);
#line 510 "gclip_select.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->_data2_ = block2_data_ref (_data2_);
	_data3_->WAIT_TIME = 900;
#line 209 "gclip_select.vala"
	selection_time = gdk_event_get_time (e);
#line 210 "gclip_select.vala"
	time_out = g_timeout_source_new ((guint) _data3_->WAIT_TIME);
#line 211 "gclip_select.vala"
	g_source_set_callback (time_out, __lambda4__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 226 "gclip_select.vala"
	g_source_attach (time_out, NULL);
#line 523 "gclip_select.c"
	_g_source_unref0 (time_out);
	block3_data_unref (_data3_);
}


#line 206 "gclip_select.vala"
static void __lambda3__gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self) {
#line 531 "gclip_select.c"
	_lambda3_ (p0, self);
}


#line 231 "gclip_select.vala"
static void _lambda5_ (GdkRectangle* rect, Block2Data* _data2_) {
#line 234 "gclip_select.vala"
	if (new_insert) {
#line 540 "gclip_select.c"
		GtkAdjustment* vadj;
#line 236 "gclip_select.vala"
		vadj = _g_object_ref0 (gtk_scrolled_window_get_vadjustment (_data2_->list_view));
#line 238 "gclip_select.vala"
		gtk_adjustment_set_value (vadj, gtk_adjustment_get_upper (vadj) - gtk_adjustment_get_page_size (vadj));
#line 546 "gclip_select.c"
		_g_object_unref0 (vadj);
	}
#line 240 "gclip_select.vala"
	new_insert = FALSE;
#line 551 "gclip_select.c"
}


#line 231 "gclip_select.vala"
static void __lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 557 "gclip_select.c"
	_lambda5_ (allocation, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->content);
		_g_object_unref0 (_data2_->list_box);
		_g_object_unref0 (_data2_->list_view);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 151 "gclip_select.vala"
gint _vala_main (char** args, int args_length1) {
#line 580 "gclip_select.c"
	gint result = 0;
	Block2Data* _data2_;
	GeeHashMap* _tmp0_;
	GtkWindow* window;
	GtkHBox* panel;
	GtkVBox* vbox;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkClipboard* _tmp3_;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
#line 153 "gclip_select.vala"
	gtk_init (&args_length1, &args);
#line 155 "gclip_select.vala"
	content_table = (_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GTK_TYPE_TREE_ITER, (GBoxedCopyFunc) _gtk_tree_iter_dup, g_free, NULL, NULL, NULL), _g_object_unref0 (content_table), _tmp0_);
#line 157 "gclip_select.vala"
	window = g_object_ref_sink ((GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL));
#line 159 "gclip_select.vala"
	panel = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 4));
#line 161 "gclip_select.vala"
	gtk_window_set_title (window, "Clipboard Selection Manager");
#line 162 "gclip_select.vala"
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 10));
#line 604 "gclip_select.c"
	_data2_->list_view = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
#line 166 "gclip_select.vala"
	gtk_scrolled_window_set_policy (_data2_->list_view, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 167 "gclip_select.vala"
	gtk_scrolled_window_set_shadow_type (_data2_->list_view, GTK_SHADOW_ETCHED_IN);
#line 610 "gclip_select.c"
	_data2_->list_box = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ());
#line 170 "gclip_select.vala"
	setup_list_box (_data2_->list_box);
#line 171 "gclip_select.vala"
	gtk_container_add ((GtkContainer*) _data2_->list_view, (GtkWidget*) _data2_->list_box);
#line 172 "gclip_select.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _data2_->list_view, TRUE, TRUE, 0);
#line 175 "gclip_select.vala"
	delete_button = (_tmp1_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label ("Delete")), _g_object_unref0 (delete_button), _tmp1_);
#line 177 "gclip_select.vala"
	g_signal_connect_data (delete_button, "released", (GCallback) __lambda1__gtk_button_released, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 182 "gclip_select.vala"
	delete_all_button = (_tmp2_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label ("Delete All")), _g_object_unref0 (delete_all_button), _tmp2_);
#line 183 "gclip_select.vala"
	g_signal_connect_data (delete_all_button, "released", (GCallback) __lambda2__gtk_button_released, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 188 "gclip_select.vala"
	gtk_box_pack_start ((GtkBox*) panel, (GtkWidget*) delete_button, FALSE, FALSE, 0);
#line 189 "gclip_select.vala"
	gtk_box_pack_start ((GtkBox*) panel, (GtkWidget*) delete_all_button, FALSE, FALSE, 0);
#line 191 "gclip_select.vala"
	gtk_box_pack_end ((GtkBox*) vbox, (GtkWidget*) panel, FALSE, FALSE, 0);
#line 192 "gclip_select.vala"
	gtk_container_add ((GtkContainer*) window, (GtkWidget*) vbox);
#line 193 "gclip_select.vala"
	gtk_window_set_default_size (window, 200, 200);
#line 194 "gclip_select.vala"
	gtk_widget_show_all ((GtkWidget*) window);
#line 196 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_button, FALSE);
#line 197 "gclip_select.vala"
	gtk_widget_set_sensitive ((GtkWidget*) delete_all_button, FALSE);
#line 199 "gclip_select.vala"
	clip = (_tmp3_ = _g_object_ref0 (gtk_clipboard_get (GDK_SELECTION_PRIMARY)), _g_object_unref0 (clip), _tmp3_);
#line 644 "gclip_select.c"
	_data2_->content = g_strdup (gtk_clipboard_wait_for_text (clip));
#line 201 "gclip_select.vala"
	if (_data2_->content != NULL) {
#line 202 "gclip_select.vala"
		add_entry_to_list_box (_data2_->list_box, _data2_->content);
#line 650 "gclip_select.c"
	}
#line 204 "gclip_select.vala"
	g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
#line 206 "gclip_select.vala"
	g_signal_connect_data (clip, "owner-change", (GCallback) __lambda3__gtk_clipboard_owner_change, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 231 "gclip_select.vala"
	g_signal_connect_data ((GtkWidget*) _data2_->list_box, "size-allocate", (GCallback) __lambda5__gtk_widget_size_allocate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 243 "gclip_select.vala"
	gtk_main ();
#line 660 "gclip_select.c"
	result = 0;
	_g_object_unref0 (vbox);
	_g_object_unref0 (panel);
	_g_object_unref0 (window);
	block2_data_unref (_data2_);
#line 244 "gclip_select.vala"
	return result;
#line 668 "gclip_select.c"
}


#line 151 "gclip_select.vala"
int main (int argc, char ** argv) {
#line 151 "gclip_select.vala"
	g_type_init ();
#line 151 "gclip_select.vala"
	return _vala_main (argv, argc);
#line 678 "gclip_select.c"
}




