/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#ifndef __GCJPLUGINFACTORY_H__
#define __GCJPLUGINFACTORY_H__

#include <nsIComponentManager.h>
#include <nsIFile.h>
#include <nsIGenericFactory.h>
#include <nsIJVMPlugin.h>
#include <nsIPlugin.h>
#include <nsISupports.h>

#define NS_OJIPLUGIN_CID { \
  0x6ad7ba5c, 0x9ce1, 0x43d1, \
  { 0x80, 0xc9, 0xe4, 0x99, 0x1a, 0x7b, 0x18, 0x1e } \
}

class GCJPluginFactory : public nsIPlugin, public nsIJVMPlugin
{
 public:

  GCJPluginFactory ();
  virtual ~GCJPluginFactory ();

  NS_DECL_ISUPPORTS
  NS_DECL_NSIPLUGIN
    
  static NS_METHOD RegisterSelf (nsIComponentManager* aCompMgr,
                                 nsIFile* aPath,
                                 const char* aRegistryLocation,
                                 const char* aComponentType,
                                 const nsModuleComponentInfo *info);
  static NS_METHOD UnregisterSelf (nsIComponentManager* aCompMgr,
                                   nsIFile* aPath,
                                   const char* aRegistryLocation,
                                   const nsModuleComponentInfo *info);
    
  static NS_METHOD CreateOJIPlugin (nsISupports *aOuter, REFNSIID aIID,void * *result);
  NS_IMETHOD CreateInstance (nsISupports *aOuter, REFNSIID aIID, void * *result);
  NS_IMETHOD LockFactory (PRBool aLock);
    
  NS_IMETHOD AddToClassPath (const char* dirPath);
  NS_IMETHOD RemoveFromClassPath (const char* dirPath);
  NS_IMETHOD GetClassPath (const char* *result);
  NS_IMETHOD GetJavaWrapper (JNIEnv* jenv, jint obj, jobject *jobj);
  NS_IMETHOD CreateSecureEnv (JNIEnv* proxyEnv, nsISecureEnv* *outSecureEnv);
  NS_IMETHOD SpendTime (PRUint32 timeMillis);
  NS_IMETHOD UnwrapJavaWrapper (JNIEnv* jenv, jobject jobj, jint* obj);

 private:

  void StartVM ();
  void StopVM ();

  static JavaVM* s_jvm;
  static JNIEnv* s_jniEnv;
  static int s_started;
  
  char* m_classpath;
};

#endif // __GCJPLUGINFACTORY_H__
