/* AppletStub.java -- implements the applet-browser interface
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;

class AppletStub implements java.applet.AppletStub
{
  private AppletTag tag;
  private AppletContext context;

  AppletStub (AppletTag tag, AppletContext context)
  {
    this.tag = tag;
    this.context = context;
  }

  ////////////////////////////////
  ////// AppletStub Methods //////
  ////////////////////////////////

  // Tests whether or not this applet is currently active. An applet
  // becomes active just before the browser invokes start (), and
  // becomes inactive just before the browser invokes stop ().
  public boolean isActive ()
  {
    return true;
  }

  // Returns the basename URL of the document in which this applet is
  // embedded.
  public URL getDocumentBase ()
  {
    return tag.documentbase;
  }

  // Returns the URL of the code base for this applet.
  public URL getCodeBase () throws MalformedURLException
  {
    return tag.prependCodebase ("");
  }

  // Returns the value of the specified parameter that was specified
  // in the <code>APPLET</code> tag for this applet.
  public String getParameter (String name)
  {
    return (String) tag.parameters.get (name);
  }

  // Returns the applet context for this applet.
  public AppletContext getAppletContext ()
  {
    return context;
  }

  // Requests that the applet window for this applet be resized.
  public void appletResize (int width, int height)
  {
  }
}
