/* StandaloneAppletWindow.java -- an applet frame
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.*;
import java.util.StringTokenizer;
import java.util.HashMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.net.*;


class StandaloneAppletWindow extends Frame
{
  private static int test_window_count = 0;

  private static HashMap contexts = new HashMap ();
  Applet applet;
  Label status = new Label ();

  StandaloneAppletWindow (AppletTag tag, List appletWindows)
  {
    appletWindows.add (this);
    applet = AppletViewer.createApplet (tag);

    if (contexts.get (tag.codebase) == null)
      contexts.put (tag.codebase, new StandaloneAppletContext (appletWindows));

    setLayout (new BorderLayout());
    add (applet, BorderLayout.CENTER);
    add (status, BorderLayout.SOUTH);

    addWindowListener (new WindowAdapter ()
      {
	public void windowClosing (WindowEvent event)
	{
	  applet.stop();
	  StandaloneAppletWindow.this.hide();
	  System.exit (0);
	}
      });

    addNotify();

    MenuBar menuBar = new MenuBar();
    Menu menuFile = new Menu ("File");
    menuBar.add (menuFile);
    menuFile.add (new MenuItem ("Quit"));
    setMenuBar (menuBar);

    AppletContext context = (AppletContext) contexts.get (tag.codebase);
    ((StandaloneAppletContext) context).addApplet (applet);

    applet.setStub (new AppletStub (tag, context));

    applet.setSize (tag.dimensions.width,
		    tag.dimensions.height);
    applet.setVisible (true);

    applet.init();
    applet.start();

    setTitle (tag.documentbase.toString ());
    Insets insets = getInsets ();
    setSize (tag.dimensions.width + insets.left + insets.right,
	     tag.dimensions.height + insets.top + insets.bottom);

    String test_window_count = AppletViewer.getenv ("GCJAPPLETVIEWER_NOGUI");
    if (test_window_count == null)
      setVisible (true);
    else
      {
	if (++this.test_window_count
	    == Integer.decode (test_window_count).intValue ())
	  System.exit (0);
      }
  }

  void showStatus (String status)
  {
    this.status.setText (status);
  }
}
