/* PluginAppletContext.java -- an applet's context within a web browser
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.java.awt.EmbeddedWindow;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * PluginAppletContext represents the context within a webpage of a
 * group of applets that all share the same codebase.
 */
class PluginAppletContext implements AppletContext
{
  private HashMap applets = new HashMap ();
  private HashMap streams = new HashMap ();

  void addApplet (Applet applet)
  {
    if (applets.get (applet.getName ()) != null)
      {
	System.err.println ("an applet named " + applet.getName ()
			    + " has already been added "
			    + "to this applet context");
	return;
      }
    applets.put (applet.getName (), applet);
  }

  ///////////////////////////////
  //// AppletContext methods ////
  ///////////////////////////////

  public AudioClip getAudioClip (URL url)
  {
    throw new Error ("not implemented");
  }

  public Image getImage (URL url)
  {
    return Toolkit.getDefaultToolkit().getImage (url);
  }

  public Applet getApplet (String name)
  {
    return (Applet) applets.get (name);
  }

  public Enumeration getApplets()
  {
    return Collections.enumeration (applets.values ());
  }

  public void showDocument (URL url)
  {
    showDocument (url, "_self");
  }

  // FIXME: implement.
  public void showDocument (URL url, String target)
  {
    System.err.println ("showDocument is not implemented in plugin mode");
  }

  // FIXME: implement.
  public void showStatus (String status)
  {
    System.err.println ("showStatus is not implemented in plugin mode");
  }

  public void setStream (String key, InputStream stream)
  {
    streams.put (key, stream);
  }

  public InputStream getStream (String key)
  {
    return (InputStream) streams.get (key);
  }

  public Iterator getStreamKeys ()
  {
    return streams.keySet ().iterator ();
  }
}
