/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class AppletContextImpl implements AppletContext
{
  private Hashtable applets;

  // FIXME: From JDK 1.4.2 documentaion: For security reasons, mapping of
  // streams and keys exists for each codebase. In other words, applet from
  // one codebase cannot access the streams created by an applet from a
  // different codebase
  private Hashtable streams;
 
  AppletContextImpl()
  {
    // Do nothing here
  }

  public void addApplet (Applet applet)
  {
    applets.put (applet.getName(), applet);
  }

  public Applet getApplet (String name)
  {
    return (Applet) applets.get (name);
  }

  public Enumeration getApplets()
  {
    return applets.elements();
  }

  public AudioClip getAudioClip (URL url)
  {
    throw new Error ("not implemented");
  }

  public Image getImage (URL url)
  {
    return Toolkit.getDefaultToolkit().getImage (url);
  }

  public InputStream getStream (String key)
  {
    return (InputStream) streams.get (key);
  }

  public Iterator getStreamKeys()
  {
    return streams.keySet().iterator();
  }

  public void setStream (String key, InputStream stream)
  {
    if (streams != null)
      streams.put (key, stream);
    else
      streams.remove (key);
  }

  public void showDocument (URL url)
  {
    showDocument (url, "_self");
  }

  public native void showDocument (URL url, String target);

  public native void showStatus (String status);
}
