/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.applet;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import gnu.java.awt.EmbeddedWindow;
import java.awt.GridLayout;

public class AppletLoader
{
  public static Applet loadApplet (URL codeBase, String appletName)
  {
    // FIXME: Remove DEBUG output
    System.out.println ("AppletLoader.loadApplet: codeBase: " + codeBase + " appletName: " + appletName);

    Object applet = null;
    
    try
      {
	URLClassLoader loader = new URLClassLoader (new URL[] { codeBase });
	Class appletClass = loader.loadClass (appletName);
	applet = appletClass.newInstance();

	if (!(applet instanceof Applet))
	  throw new ClassCastException ("Loaded class is not derived from java.applet.Applet");
      }
    catch (ClassNotFoundException e)
      {
	e.printStackTrace();
      }
    catch (IllegalAccessException e)
      {
	e.printStackTrace();
      }
    catch (InstantiationException e)
      {
	e.printStackTrace();
      }

    return (Applet) applet;;
  }

  private String code;
  private URL codeBase;
  private URL documentBase;
  private String archive;
  private Hashtable params = new Hashtable();
  private Applet applet;
  private EmbeddedWindow window;

  public AppletLoader()
  {
    // Do nothing here.
  }

  public void setEmbeddedWindow (EmbeddedWindow window)
  {
    this.window = window;
    if (applet != null)
      {
        window.add (applet);
        window.show ();
      }
  }

  public void setCode (String code)
  {
    if (code.endsWith (".class"))
      {
        code = code.substring (0, code.lastIndexOf (".class"));
      }
    this.code = code;
  }

  public void setCodeBase (String base)
  {
    try
      {
        if (!base.endsWith ("/"))
          {
            base = base.substring (0, base.lastIndexOf ('/') + 1);
          }
        
	codeBase = new URL (base);
      }
    catch (MalformedURLException e)
      {
      }
  }

  public void setDocumentBase (String base)
  {
    try
      {
	documentBase = new URL (base);
      }
    catch (MalformedURLException e)
      {
      }

    if (codeBase == null)
      setCodeBase (base);
  }

  public void setArchive (String archive)
  {
    this.archive = archive;
  }

  public void addParameter (String name, String value)
  {
    params.put (name, value);
  }

  public synchronized Applet loadApplet()
  {
    // Check if applet is already loaded.
    if (applet != null)
      return applet;

    // FIXME: Remove DEBUG output
    System.out.println (code);
    System.out.println (codeBase);
    System.out.println (documentBase);
    System.out.println (archive);
    
    try
      {
	applet = loadApplet (codeBase, code);

	// Return null when applet couldn't be loaded.
	if (applet != null)
          {
            // Create AppletContext and AppletStub and set it.
            AppletContextImpl context = new AppletContextImpl();
            AppletStubImpl stub = new AppletStubImpl (context, codeBase,
                                                      documentBase, params);
            applet.setStub (stub);
          }
      }
    catch (Exception e)
      {
	e.printStackTrace();
      }

    return applet;
  }
}
