// -*- C++ -*-

/* 
 * Gnome Chemistry Utils
 * filechooser.h 
 *
 * Copyright (C) 2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCU_FILECHOOSER_H
#define GCU_FILECHOOSER_H

#include <gtk/gtkstock.h>
#include <gtk/gtkfilechooser.h>
#include <list>

using namespace std;

namespace gcu
{

class Application;
class Document;

class FileChooser
{
public:
	FileChooser (Application *App, bool Save, list<char const*> mime_types, Document *pDoc = NULL, char const *title = NULL, GtkWidget *extra_widget = NULL);
	
private:
	GtkFileChooser* dialog;
	bool m_bSave;
	Application* m_pApp;
	Document* m_pDoc;
};

}

#endif	// GCU_FILECHOOSER_H
