// -*- C++ -*-

/* 
 * GChemPaint library
 * application.h 
 *
 * Copyright (C) 2004-2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_APPLICATION_H
#define GCHEMPAINT_APPLICATION_H

#include "tool.h"
#include "bonobo/bonobo-ui-node.h"
#include <gcu/application.h>
#include <gcu/dialog.h>
#include <set>
#include <string>
#include <map>

using namespace gcu;

typedef struct
{
	char const *name;
	unsigned char const *data_24;
} gcpIconDesc;

class gcpWindow;
	
class gcpApplication: public Application
{
public:
	gcpApplication();
	virtual ~gcpApplication();

	virtual void ActivateMenu(const string& menuname, bool activate);
	virtual void ToggleMenu(const string& menuname, bool active) = 0;
	virtual void ActivateTool(const string& toolname, bool activate);
	virtual void ActivateToolItem(const string& itemname, bool activate);
	virtual void ClearStatus();
	virtual void SetStatusText(const char* text);
	void AddUI(const char* filename);
	virtual GtkWindow* GetWindow() = 0;
	void SetMenu(const string& menuname, GtkWidget* menu) {Menus[menuname] = menu;}
	GtkWidget* GetMenu(const string& name) {return Menus[name];}
	gcpTool* GetActiveTool() {return m_pActiveTool;}
	gcpDocument* GetActiveDocument() {return m_pActiveDoc;}
	void SetActiveDocument (gcpDocument* pDoc) {m_pActiveDoc = pDoc;}
	gcpTool* GetTool(const string& name) {return Tools[name];}
	void SetTool (const string& toolname, gcpTool* tool) {Tools[toolname] = tool;}
	GtkWidget* GetToolItem(const string& name) {return ToolItems[name];}
	void SetToolItem(const string& name, GtkWidget* w) {ToolItems[name] = w;}
	void SetDialog(const string& name, Dialog* dialog) {Dialogs[name] = dialog;}
	Dialog* GetDialog(const string& name) {return Dialogs[name];}
	void SetCurZ(int Z) {m_CurZ = Z;}
	int GetCurZ() {return m_CurZ;}
	void OnSaveAs();
	bool FileProcess(const gchar* filename, const gchar* mime_type, bool bSave, GtkWindow *window, Document *pDoc = NULL);
	void SaveWithBabel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, int Type);
	void OpenWithBabel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, int Type);
	void SaveGcp(const gchar* filename, gcpDocument* pDoc);
	void OpenGcp(const gchar* filename, gcpDocument* pDoc);
	char* GetFontName() {return FontName;}
	void SetFontName(char* fontname);
	xmlDocPtr GetXmlDoc() {return XmlDoc;}
	void SetCallback(const string& name, GCallback cb) {Callbacks[name] = cb;}
	GCallback GetCallback(const string& name) {return Callbacks[name];}
	void OnShowElements ();
	void OnSaveAsImage ();
	bool HaveGhemical () {return m_Have_Ghemical;}
	bool HaveInChI () {return m_Have_InChI;}
	int GetDocsNumber () {return m_Docs.size ();}
	void Zoom (double zoom);
	void AddActions (GtkRadioActionEntry const *entries, int nb, char const *ui_description, gcpIconDesc const *icons);
	void RegisterToolbar (char const *name, int index);
	void OnToolChanged (GtkAction *current);
	void AddWindow (gcpWindow *window);
	void DeleteWindow (gcpWindow *window);
	void NotifyIconification (bool iconified);
	void NotifyFocus (bool has_focus, gcpWindow *window = NULL);
	void CheckFocus ();
	void CloseAll ();
	list<char const*> &GetSupportedMimeTypes () {return m_SupportedMimeTypes;}

	// virtual menus actions:
	virtual void OnFileNew () = 0;
	virtual void OnFileClose () = 0;

protected:
//	virtual void AddDocument(gcpDocument* pDoc) = 0;
	void InitTools();
	void BuildTools ();
	void ShowTools (bool visible);

private:
	void MergeNodes(BonoboUINode* Dest, BonoboUINode* Source);

protected:
	int m_CurZ;
	gcpDocument *m_pActiveDoc;
	gcpWindow *m_pActiveWin;
//	std::list<gcpDocument*> m_Docs;
	map <string, GtkWidget*> Menus;
	map <string, GtkWidget*> ToolItems;
	map <string, GtkWidget*> Toolbars;
	map <string, gcpTool*> Tools;
	map <string, Dialog*> Dialogs;
	map <string, GCallback> Callbacks;
	gcpTool* m_pActiveTool;
	static bool m_bInit, m_Have_Ghemical, m_Have_InChI;
	static map<string, string> m_SupportedPixbufFormats;
	BonoboUINode* m_pNode;
	char *FontName;
	xmlDocPtr XmlDoc;
	unsigned m_NumWindow; //used for new files (Untitled%d)

private:
	GtkIconFactory *IconFactory;
	list<char const*> UiDescs;
	GtkRadioActionEntry* RadioActions;
	int m_entries;
	map<int, string> ToolbarNames;
	unsigned m_NumDoc; //used to build the name of the action associated with the menu
	std::set<gcpWindow*> m_Windows;
	int visible_windows;
	bool focused;
	list<char const*> m_SupportedMimeTypes;
	unsigned m_idle;
};

extern list<gcpApplication*> Apps;

#endif //GCHEMPAINT_APPLICATION_H
