// -*- C++ -*-

/* 
 * GChemPaint text plugin
 * texttool.h 
 *
 * Copyright (C) 2002-2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_TEXT_TOOL_H
#define GCHEMPAINT_TEXT_TOOL_H

#include "lib/tool.h"
#include <list>

using namespace std;

class gcpTextTool: public gcpTool
{
public:
	gcpTextTool (gcpApplication *App, string Id = "Text");
	virtual ~gcpTextTool ();

	virtual bool OnClicked ();
	virtual bool Deactivate ();
	virtual void Activate ();
	virtual bool OnEvent (GdkEvent *event);
	virtual bool NotifyViewChange ();
	bool OnToggled (GtkWidget *btn);
	bool OnFont ();
	virtual bool DeleteSelection ();
	virtual bool CopySelection (GtkClipboard *clipboard);
	virtual bool CutSelection (GtkClipboard *clipboard);
	virtual bool PasteSelection (GtkClipboard *clipboard);
	virtual bool OnReceive (GtkClipboard *clipboard, GtkSelectionData *data, int type);
	virtual bool OnUndo ();
	virtual bool OnRedo ();
	void PushNode (xmlNodePtr node);
	void OnGetData (GtkClipboard *clipboard, GtkSelectionData *selection_data,  guint info);
	GtkWidget *GetPropertyPage ();
	void OnSelectFamily (GtkTreeSelection *selection);
	void OnSelectFace (GtkTreeSelection *selection);
	void OnSelectSize (int size);

protected:
	virtual bool Unselect ();

private:
	void BuildAttributeList ();
	void SelectBestFontFace ();

protected:
	GnomeCanvasRichTextExt* m_Active;
	list<xmlNodePtr> m_UndoList, m_RedoList;
	xmlNodePtr m_CurNode, m_InitNode;

private:
	bool m_bUndo;
	PangoFontDescription *m_FontDesc, *m_DefaultFontDesc;
	GtkListStore *m_FamilyList, *m_FaceList, *m_SizeList;
	GtkTreeView *m_FacesTree;
	GtkEntry *m_SizeEntry;
	map<string, PangoFontFamily*> m_Families;
	map<string, PangoFontFace*> m_Faces;
	PangoStyle m_Style;
	PangoWeight m_Weight;
	PangoStretch m_Stretch;
	PangoVariant m_Variant;
	int m_Size;
	guint m_FaceSignal, m_SizeSignal;
	gpointer m_FaceSel, m_SizeSel;
	bool m_Dirty;
};

#endif	//GCHEMPAINT_TEXT_TOOL_H
