/* libgcpcanvas/gcp-canvas-pango.h
 *
 * Copyright (c) 2005 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GNOME_CANVAS_PANGO_H
#define GNOME_CANVAS_PANGO_H

#include <libgnomecanvas/gnome-canvas.h>

G_BEGIN_DECLS

#define GNOME_TYPE_CANVAS_PANGO             (gnome_canvas_pango_get_type ())
#define GNOME_CANVAS_PANGO(obj)             (GTK_CHECK_CAST ((obj), GNOME_TYPE_CANVAS_PANGO, GnomeCanvasPango))
#define GNOME_CANVAS_PANGO_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_CANVAS_PANGO, GnomeCanvasPangoClass))
#define GNOME_IS_CANVAS_PANGO(obj)          (GTK_CHECK_TYPE ((obj), GNOME_TYPE_CANVAS_PANGO))
#define GNOME_IS_CANVAS_PANGO_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_CANVAS_PANGO))
#define GNOME_CANVAS_PANGO_GET_CLASS(obj)   (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_CANVAS_PANGO, GnomeCanvasPangoClass))

typedef struct _GnomeCanvasPango             GnomeCanvasPango;
typedef struct _GnomeCanvasPangoPrivate      GnomeCanvasPangoPrivate;
typedef struct _GnomeCanvasPangoClass        GnomeCanvasPangoClass;

struct _GnomeCanvasPango {
	GnomeCanvasItem item;

    GnomeCanvasPangoPrivate *_priv;
};

struct _GnomeCanvasPangoClass {
	GnomeCanvasItemClass parent_class;
};

GType gnome_canvas_pango_get_type(void) G_GNUC_CONST;

PangoLayout* gnome_canvas_pango_get_layout (GnomeCanvasPango *text);
void gnome_canvas_pango_set_layout (GnomeCanvasPango *text, PangoLayout* layout);

G_END_DECLS

#endif /* GNOME_CANVAS_PANGO_H */
