// -*- C++ -*-

/* 
 * GChemPaint selection plugin
 * plugin.cc 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "lib/molecule.h"
#include "selectiontool.h"
#include "erasertool.h"
#include "group.h"

gcpSelectionPlugin plugin;

static Object* CreateGroup ()
{
	return new gcpGroup ();
}

gcpSelectionPlugin::gcpSelectionPlugin(): gcpPlugin()
{
	GroupType = Object::AddType ("group", CreateGroup);
}

gcpSelectionPlugin::~gcpSelectionPlugin()
{
}

void gcpSelectionPlugin::Populate (gcpApplication* App)
{
	App->AddUI (DATADIR"/gchempaint-unstable/ui/selection.xml");
	new gcpSelectionTool (App);
	new gcpEraserTool (App);
	App->ActivateTool ("Select", true);
}
