/* 
 * GChemPaint GOffice component
 * gofficeapp.h
 *
 * Copyright (C) 2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCP_GOFFICE_APP_H
#define GCP_GOFFICE_APP_H

#include <lib/application.h>

class gcpGOfficeApplication: public gcpApplication
{
public:
	gcpGOfficeApplication ();
	virtual ~gcpGOfficeApplication ();

	virtual GtkWindow* GetWindow();
	virtual void RemoveDocument(gcpDocument* pDoc);
	virtual void ToggleMenu(const string& menuname, bool active);

	gcpDocument *ImportDocument (const string& mime_type, const char* data, int length);

protected:
	virtual void AddDocument(gcpDocument* pDoc);
};

#endif	// GCP_GOFFICE_APP_H
