// -*- C++ -*-

/* 
 * GChemPaint text plugin
 * plugin.cc 
 *
 * Copyright (C) 2004 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "lib/text.h"
#include "lib/fragment.h"
#include "texttool.h"
#include "fragmenttool.h"

gcpTextPlugin plugin;

gcpTextPlugin::gcpTextPlugin(): gcpPlugin()
{
}

gcpTextPlugin::~gcpTextPlugin()
{
}

void gcpTextPlugin::Populate (gcpApplication* App)
{
	App->AddUI (PKGDATADIR"/ui/text.xml");
	new gcpTextTool (App);
	new gcpFragmentTool (App);
}
