// -*- C++ -*-

/* 
 * GChemPaint templates plugin
 * templatetree.h 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_TEMPLATETREE_H
#define GCHEMPAINT_TEMPLATETREE_H

#include "gchempaint-config.h"
#include "lib/application.h"
#include <map>
#include <string>
#include <set>
#include <libxml/tree.h>
#include <gtk/gtk.h>

using namespace std;

class gcpTemplate
{
public:
	gcpTemplate ();
	~gcpTemplate();

	string name;
	string category;
	bool writeable;
	xmlNodePtr node;
};

extern map<string, gcpTemplate*> Templates, TempbyName;
extern set<string> categories;
extern xmlDocPtr user_templates;

//Template tree item
class gcpTemplateTree: public gcpTool
{
public:
	gcpTemplateTree(gcpApplication* App);
	~gcpTemplateTree();

	GtkTreeModel* GetModel () {return (GtkTreeModel*) model;}
	gcpTemplate* GetTemplate (string path);
	void SetTemplate (gcpTemplate *t);
	const char* GetPath (gcpTemplate *t);
	void AddTemplate (string& key);
	void DeleteTemplate (string& key);
	void UpdateMaps ();
	void SetCombo (GtkWidget *w) {combo = GTK_COMBO_BOX (w);}

private:
	GtkTreeStore *model;
	GtkComboBox *combo;
	map<string, gcpTemplate*> m_Templates;
	map<gcpTemplate*, string> m_Paths;
};

#endif //GCHEMPAINT_TEMPLATETREE_H
