// -*- C++ -*-

/* 
 * GChemPaint
 * gchempaint-bonobo.cc 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "gchempaint-bonobo.h"
#include "lib/view.h"
#include "lib/widgetdata.h"
#include "bonoboapp.h"
#include <stdlib.h>
#include <unistd.h>

extern int CurElt;

/*******************************************************************************
 * Persist Stream implementation
 ******************************************************************************/
#define PERSIST_STREAM_TYPE         (persist_stream_get_type ())
#define PERSIST_STREAM(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), PERSIST_STREAM_TYPE, PersistStream))
#define PERSIST_STREAM_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), PERSIST_STREAM_TYPE, PersistStreamClass))
#define PERSIST_STREAM_IS_OBJECT(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), PERSIST_STREAM_TYPE))
#define PERSIST_STREAM_IS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), PERSIST_STREAM_TYPE))
#define PERSIST_STREAM_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), PERSIST_STREAM_TYPE, PersistStreamClass))

typedef struct {
	BonoboPersist parent;
	gcpDocument* pDoc;
} PersistStream;

typedef struct {
	BonoboPersistClass parent_class;

	POA_Bonobo_PersistStream__epv epv;
} PersistStreamClass;

GType persist_stream_get_type (void);

static void on_load(gpointer p, Bonobo_Stream stream, const Bonobo_Persist_ContentType type, CORBA_Environment  *ev)
{
	PersistStream *ps = (PersistStream*)bonobo_object(p);
	if (!ps->pDoc) return;
	CORBA_long l = Bonobo_Stream_seek(stream, 0, Bonobo_Stream_SeekEnd, ev);
	Bonobo_Stream_seek(stream, 0, Bonobo_Stream_SeekSet, ev);
	Bonobo_Stream_iobuf*  buffer;
	Bonobo_Stream_read(stream, l, &buffer, ev);
	char buf[l+1];

	memcpy(buf, buffer->_buffer, l);
	buf[l] = 0;
	xmlDocPtr xml = NULL;
	if (buf[0] != '<') //probably compressed data
	{
		char* file_name;
		int file = g_file_open_tmp("gcpXXXXXX", &file_name, NULL);
		write(file, buf, l);
		close(file);
		xml = xmlParseFile(file_name);
		remove(file_name);
		g_free(file_name);
	}
	else  xml = xmlParseMemory(buf, l);
	CORBA_free (buffer);
	if (xml)
	{
		ps->pDoc->ParseXMLTree(xml);
		xmlFreeDoc(xml);
	}
}

static void on_save(gpointer p, Bonobo_Stream stream, const Bonobo_Persist_ContentType type, CORBA_Environment  *ev)
{
	PersistStream *ps = (PersistStream*)bonobo_object(p);
	if (!ps->pDoc) return;
	xmlDocPtr xml = ps->pDoc->BuildXMLTree();
	if (xml)
	{
		char* tmp;
		int size;
		xmlDocDumpMemory(xml, (xmlChar**)(&tmp), &size);
		if (tmp)
		{
			bonobo_stream_client_write (stream, tmp, size, ev);
			xmlFree((xmlChar*)(tmp));
		}
		xmlFreeDoc(xml);
	}
}

static PersistStream* persist_stream_new()
{

	PersistStream* ps = (PersistStream*) g_object_new (PERSIST_STREAM_TYPE, NULL);
	return ps;
}

static void persist_stream_init(PersistStream *ps)
{
}

static void persist_stream_class_init(PersistStreamClass *klass)
{
	POA_Bonobo_PersistStream__epv* epv = &(klass->epv);
	epv->load = (void(*)(void*, CORBA_Object_type*, const CORBA_char*, CORBA_Environment*)) on_load;
	epv->save = (void(*)(void*, CORBA_Object_type*, const CORBA_char*, CORBA_Environment*)) on_save;
}

 BONOBO_TYPE_FUNC_FULL (
	PersistStream,                /* Glib class name */
	Bonobo_PersistStream,  /* CORBA interface name */
	BONOBO_TYPE_PERSIST,  /* parent type */
	persist_stream);               /* local prefix ie. 'echo'_class_init */

// BonoboPropertyBag callback functions

enum {
	PROP_BGCOLOR,
//	PROP_EDITABLE
};

static void get_prop(BonoboPropertyBag *bag, BonoboArg *arg, guint arg_id, CORBA_Environment *ev, GtkWidget *widget)
{
	const gchar* str;
	gcpWidgetData* pData = (gcpWidgetData*)g_object_get_data(G_OBJECT(widget), "data");

	switch (arg_id)
	{
		case PROP_BGCOLOR:
			g_object_get(G_OBJECT(pData->Background), "fill_color", &str, NULL);
			BONOBO_ARG_SET_STRING(arg, str);
			break;
/*		case PROP_EDITABLE:
			{
				gcpDocument* pDoc = (gcpDocument*) g_object_get_data(G_OBJECT(widget), "doc");
				BONOBO_ARG_SET_BOOLEAN(arg, (pDoc)? pDoc->GetEditable(): false);
			}
			break;*/
		default:
			bonobo_exception_set(ev, ex_Bonobo_PropertyBag_NotFound);
			break;
	}
}

static void set_prop (BonoboPropertyBag *bag,  const BonoboArg *arg, guint arg_id, CORBA_Environment *ev, GtkWidget *widget)
{
	gcpWidgetData* pData = (gcpWidgetData*)g_object_get_data(G_OBJECT(widget), "data");
	switch (arg_id)
	{
		case PROP_BGCOLOR:
			g_object_set(G_OBJECT(pData->Background), "fill_color", BONOBO_ARG_GET_STRING(arg));
			break;
/*		case PROP_EDITABLE:
			{
				gcpDocument* pDoc = (gcpDocument*) g_object_get_data(G_OBJECT(widget), "doc");
				if (pDoc) pDoc->SetEditable(BONOBO_ARG_GET_BOOLEAN(arg));
			}*/
			break;
		default:
			bonobo_exception_set(ev, ex_Bonobo_PropertyBag_NotFound);
			break;
	}
}

#define GCP_BONOBO_CONTROL_TYPE           (gcp_bonobo_control_get_type ())
#define GCP_BONOBO_CONTROL(o)             (G_TYPE_CHECK_INSTANCE_CAST ((o), GCP_BONOBO_CONTROL_TYPE, gcpBonoboControl))
#define GCP_BONOBO_CONTROL_CLASS(k)       (G_TYPE_CHECK_CLASS_CAST((k), GCP_BONOBO_CONTROL_TYPE, gcpBonoboControlClass))

#define GCP_BONOBO_IS_CONTROL(o)          (G_TYPE_CHECK_INSTANCE_TYPE ((o), GCP_BONOBO_CONTROL_TYPE))
#define GCP_BONOBO_IS_CONTROL_CLASS(k)    (G_TYPE_CHECK_CLASS_TYPE ((k), GCP_BONOBO_CONTROL_TYPE))
#define GCP_BONOBO_CONTROL_GET_CLASS(o)   (G_TYPE_INSTANCE_GET_CLASS ((o), GCP_BONOBO_CONTROL_TYPE, gcpBonoboControlClass))

typedef struct _gcpBonoboControl         gcpBonoboControl;
typedef struct _gcpBonoboControlClass    gcpBonoboControlClass;
	
static list<gcpBonoboControl*>ActiveControls;

struct _gcpBonoboControl {
	BonoboControl control;
	BonoboUIComponent *uic;
	PersistStream *ps;
};

struct _gcpBonoboControlClass {
	BonoboControlClass parent_class;
};

static GType gcp_bonobo_control_get_type(void);
static gcpBonoboControl *gcp_bonobo_control_new(gcpDocument *pDoc);
static gcpBonoboControl *gcp_bonobo_control_construct(gcpBonoboControl *control, gcpDocument *pDoc);

static GObjectClass *gcp_bonobo_control_parent_class;

static void
gcp_bonobo_control_destroy (BonoboObject *object)
{
	g_return_if_fail (object != NULL);
	g_return_if_fail (GCP_BONOBO_IS_CONTROL (object));
	BONOBO_OBJECT_CLASS (gcp_bonobo_control_parent_class)->destroy (object);
}

static void
gcp_bonobo_control_finalize (GObject *object)
{
	gcpBonoboControl *control;
	g_return_if_fail (object != NULL);
	g_return_if_fail (GCP_BONOBO_IS_CONTROL (object));

	control = GCP_BONOBO_CONTROL (object);
	G_OBJECT_CLASS (gcp_bonobo_control_parent_class)->finalize (object);
	delete control->ps->pDoc;
}

void gcp_bonobo_set_state(gpointer data, const char *id, const char *state)
{
	list<gcpBonoboControl*>::iterator i;
	for (i = ActiveControls.begin(); i != ActiveControls.end(); i++)
		if (*i != data)
			bonobo_ui_component_set_prop((*i)->uic, id, "state", state, NULL);
//#warning "FIXME: use data to get active tool"
/*	if ((!strcmp(id, "/commands/ViewTools")) && (!strcmp(state, "0")) && pActiveTool)
	{
		pActiveTool->Deactivate();
		pActiveTool = NULL;
	}*/
}

extern void on_file_save_as(GtkWidget* widget, void* data);

static void
on_save_as_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpApplication *App = control->ps->pDoc->GetApplication ();
	App->OnSaveAs ();
}

extern void on_print(GtkWidget* widget, void* data);

static void
on_print_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
//	on_print(NULL, control->ps->pDoc);
}

static void
on_properties_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	control->ps->pDoc->OnProperties();
}

static void
on_undo_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	control->ps->pDoc->OnUndo();
}

static void
on_redo_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	control->ps->pDoc->OnRedo();
}

static void
on_cut_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpView *pView = control->ps->pDoc->GetView();
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (pView) pView->OnCutSelection(pView->GetWidget(), clipboard);
}

static void
on_copy_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpView *pView = control->ps->pDoc->GetView();
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (pView) pView->OnCopySelection(pView->GetWidget(), clipboard);
}

static void
on_paste_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpView *pView = control->ps->pDoc->GetView();
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (pView) pView->OnPasteSelection(pView->GetWidget(), clipboard);
}

static void
on_delete_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpView *pView = control->ps->pDoc->GetView();
	if (pView) pView->OnDeleteSelection(pView->GetWidget());
}

static void
on_select_all_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	gcpBonoboControl *control = GCP_BONOBO_CONTROL(user_data);
	gcpView *pView = control->ps->pDoc->GetView();
	if (pView) pView->OnSelectAll();
}

extern void on_about(GtkWidget* widget, void* data);

static void
on_about_cb (BonoboUIComponent *uic, gpointer user_data, const char *cname)
{
	on_about(NULL, NULL);
}

extern void on_change_element(int Z);

static void ui_event_handler (BonoboUIComponent *component, const char *id,
                                  Bonobo_UIComponent_EventType  type,  const char *state,
                                  gpointer user_data)
{
/*	if (!strcmp(id, "ViewTools"))
	{
		if ((*state == '1') ^ (ToolsDlg != NULL))
		{
			on_show_tools(NULL, NULL);
			gcp_bonobo_set_state(user_data, "/commands/ViewTools", state);
			if ((!ToolsDlg) && pActiveTool)
			{
				pActiveTool->Deactivate();
				pActiveTool = NULL;
			}
		}
	}
	else if (!strcmp(id, "ViewElements"))
	{
		if ((*state == '1') ^ (MendeleievDlg != NULL))
		{
			if (MendeleievDlg) MendeleievDlg->Destroy();
			else
			{
				MendeleievDlg = new gcpMendeleievDlg(CurElt);
				MendeleievDlg->SetCallBack(&on_change_element);
			}
			gcp_bonobo_set_state(user_data, "/commands/ViewElements", state);
		}
	}*/
}

static BonoboUIVerb gcp_verbs[] = {
	BONOBO_UI_VERB ("SaveAs", on_save_as_cb),
	BONOBO_UI_VERB ("Print", on_print_cb),
	BONOBO_UI_VERB ("Properties", on_properties_cb),
	BONOBO_UI_VERB ("Undo", on_undo_cb),
	BONOBO_UI_VERB ("Redo", on_redo_cb),
	BONOBO_UI_VERB ("Cut", on_cut_cb),
	BONOBO_UI_VERB ("Copy", on_copy_cb),
	BONOBO_UI_VERB ("Paste", on_paste_cb),
	BONOBO_UI_VERB ("Clear", on_delete_cb),
	BONOBO_UI_VERB ("Select All", on_select_all_cb),
	BONOBO_UI_VERB ("HelpAbout", on_about_cb),
	BONOBO_UI_VERB_END
};

static void
gcp_bonobo_control_activate (BonoboControl *object, gboolean state)
{
	gcpBonoboControl *control;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GCP_BONOBO_IS_CONTROL (object));

	control = GCP_BONOBO_CONTROL (object);
	if (!control->ps->pDoc->GetEditable()) return;

	if (state)
	{
		Bonobo_UIContainer ui_container;
		
		ui_container = bonobo_control_get_remote_ui_container (BONOBO_CONTROL (control), NULL);
		if (ui_container != CORBA_OBJECT_NIL)
		{
			bonobo_ui_component_set_container (control->uic, ui_container, NULL);
			bonobo_ui_util_set_ui(control->uic, PREFIX,
								"gchempaint.xml", "gchempaint", NULL);
			bonobo_ui_component_add_verb_list_with_data(control->uic, gcp_verbs, control);
			g_signal_connect(control->uic, "ui-event", G_CALLBACK(ui_event_handler), control);
			if (bonobo_ui_component_get_container(control->uic) != CORBA_OBJECT_NIL)
			{
//				if (MendeleievDlg)
					bonobo_ui_component_set_prop(control->uic, "/commands/ViewElements", "state", "1", NULL);
				
				bonobo_ui_component_set_prop(control->uic, "/menu/Help/BuiltMenuItems/Helpgchempaint0", "label", _("GChemPaint help contents"), NULL);
				bonobo_ui_component_set_prop(control->uic, "/menu/Help/BuiltMenuItems/Helpgchempaint0", "tip", _("View help for GChemPaint"), NULL);
				ActiveControls.push_front(control);
			}
		}
	}
	else
	{
		bonobo_ui_component_unset_container (control->uic, NULL);
		ActiveControls.remove(control);
	}

	if (BONOBO_CONTROL_CLASS (gcp_bonobo_control_parent_class)->activate)
		BONOBO_CONTROL_CLASS (gcp_bonobo_control_parent_class)->activate (object, state);
}

void gcp_bonobo_control_class_init (gcpBonoboControlClass *klass)
{
	GObjectClass *gobject_class = (GObjectClass *)klass;
	BonoboObjectClass *bonobo_object_class = (BonoboObjectClass *)klass;
	BonoboControlClass *control_class = (BonoboControlClass *)klass;

	gcp_bonobo_control_parent_class = (GObjectClass *)g_type_class_peek_parent ((GObjectClass *)klass);

	bonobo_object_class->destroy = gcp_bonobo_control_destroy;
	gobject_class->finalize = gcp_bonobo_control_finalize;
	control_class->activate = gcp_bonobo_control_activate;
}

static void
gcp_bonobo_control_init (gcpBonoboControl *control)
{
}

BONOBO_TYPE_FUNC (gcpBonoboControl, BONOBO_TYPE_CONTROL, gcp_bonobo_control);

gcpBonoboControl* gcp_bonobo_control_construct(gcpBonoboControl *control, gcpDocument *pDoc)
{
	GtkWidget             *widget;
	BonoboPropertyBag     *pb;
	BonoboPropertyControl *pc;
	CORBA_Environment ev;
	
	g_return_val_if_fail (pDoc != NULL, NULL);
	g_return_val_if_fail (control != NULL, NULL);
	g_return_val_if_fail (GCP_BONOBO_IS_CONTROL (control), NULL);

	widget = pDoc->GetView()->CreateNewWidget();
	pDoc->SetEditable (false);

	bonobo_control_construct (BONOBO_CONTROL (control), widget);
	pb = bonobo_property_bag_new( 
			(void (*)(BonoboPropertyBag*, BonoboArg*, unsigned int,
   			CORBA_Environment*, void*))get_prop,
			(void (*)(BonoboPropertyBag*, const BonoboArg*, unsigned int,
   			CORBA_Environment*, void*))set_prop,
			widget);
	bonobo_control_set_properties((BonoboControl*)control, bonobo_object_corba_objref(BONOBO_OBJECT(pb)), &ev);
	bonobo_property_bag_add(pb, "bgcolor", PROP_BGCOLOR,
				 BONOBO_ARG_STRING, NULL,
				 _("Background color"),
				 0);
/*	bonobo_property_bag_add(pb, "bonobo:editable", PROP_EDITABLE,
				 BONOBO_ARG_BOOLEAN, NULL,
				 _("Editable file flag"),
				 FALSE);*/
	
	control->ps = persist_stream_new();
	control->ps->pDoc = pDoc;
	pDoc->SetBonoboPersist((BonoboPersist*)control->ps);
	bonobo_object_add_interface((BonoboObject*)control, (BonoboObject*)control->ps);
	
	bonobo_control_set_automerge((BonoboControl*)control, true);
	control->uic = bonobo_control_get_ui_component((BonoboControl*)control);
	pDoc->SetBonoboUI(control->uic);
	g_signal_connect (control, "activate", G_CALLBACK (gcp_bonobo_control_activate),NULL);

	return control;
}

gcpBonoboControl *
gcp_bonobo_control_new (gcpDocument *pDoc)
{
	gcpBonoboControl *control;

	control = (gcpBonoboControl*) g_object_new (GCP_BONOBO_CONTROL_TYPE, NULL);

	return gcp_bonobo_control_construct (control, pDoc);
}


BonoboObject * gchempaint_factory(BonoboGenericFactory * fact, const char *component_id, void* data)
{
	g_return_val_if_fail (fact != NULL, NULL);
	g_return_val_if_fail (component_id != NULL, NULL);

	BonoboObject *retval;
	gcpBonoboApp* App = new gcpBonoboApp();
	gcpDocument* pDoc =  new gcpDocument(App, false);
	if (!pDoc) return NULL;
	if (!strcmp (component_id, "OAFIID:gchempaint_control"))
	{
		retval = (BonoboObject*) gcp_bonobo_control_new(pDoc);
		if (!retval)  delete pDoc;
	}
	else
	{
		g_warning ("Unknown IID `%s' requested", component_id);
		delete pDoc;
		return NULL;
	}

	return retval;
}

int main (int argc, char *argv[])
{
	bindtextdomain(PACKAGE, DATADIR"/locale");
#ifdef ENABLE_NLS
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	textdomain(PACKAGE);
	gtk_init (&argc, &argv);
	BONOBO_FACTORY_INIT ("gchempaint", VERSION, &argc, argv);		
	return bonobo_generic_factory_main ("OAFIID:gchempaint_factory", gchempaint_factory, NULL);
}
