// -*- C++ -*-

/* 
 * GChemPaint library
 * tool.cc
 *
 * Copyright (C) 2001-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "tool.h"
#include "document.h"
#include "application.h"

gcpTool* pActiveTool = NULL;

gcpTool::gcpTool(gcpApplication *App, string Id)
{
	name = Id;
	m_pApp = App;
	App->SetTool (Id, this);
	m_pObject = NULL;
	m_pItem = NULL;
	m_bChanged = m_bPressed = false;
	m_OptionDialog = NULL;
	m_pData = NULL;
}

gcpTool::~gcpTool()
{
	m_pApp->SetTool (name, NULL);
}

bool gcpTool::OnClicked (gcpView* pView, Object* pObject, double x, double y, unsigned int state)
{
	m_x0 = m_x1 = lastx = x;
	m_y0 = m_y1 = lasty = y;
	m_nState = state;
	m_bPressed = true;
	m_pObject = pObject;
	if (pObject)
		m_pObjectGroup = pObject->GetGroup ();
	m_pView = pView;
	m_pWidget = m_pView->GetWidget ();
	m_pData = (gcpWidgetData*) g_object_get_data (G_OBJECT(m_pWidget), "data");
	m_pGroup = gnome_canvas_root (GNOME_CANVAS (m_pWidget));
	m_pBackground = m_pView->GetBackground ();
	m_dZoomFactor = m_pView->GetZoomFactor ();
	Object* pAtom;
	if (m_pObject && ((pAtom = m_pObject->GetAtomAt (m_x0 / m_dZoomFactor, m_y0 / m_dZoomFactor))))
			m_pObject = pAtom;
	m_bAllowed = true;
	return OnClicked ();
}

void gcpTool::OnDrag(double x, double y, unsigned int state)
{
	m_x = lastx = x;
	m_y = lasty = y;
	m_nState = state;
	OnDrag();
}

void gcpTool::OnRelease(double x, double y, unsigned int state)
{
	m_x = lastx = x;
	m_y = lasty = y;
	m_nState = state;
	m_bPressed = false;
	OnRelease();
	double x1, y1, x2, y2;
	if (m_pItem)
	{
//		gnome_canvas_item_get_bounds(GNOME_CANVAS_ITEM(m_pItem), &x1, &y1, &x2, &y2);
		gtk_object_destroy(GTK_OBJECT(GNOME_CANVAS_ITEM(m_pItem)));
//		gnome_canvas_request_redraw(GNOME_CANVAS(m_pWidget), (int)x1, (int)y1, (int)x2, (int)y2);
		m_pItem = NULL;
	}
	m_pView->GetDoc()->FinishOperation();
	m_pObject = NULL;
	m_bChanged = false;
	g_signal_emit_by_name(m_pWidget, "update_bounds");
}

bool gcpTool::OnRightButtonClicked (gcpView* pView, Object* pObject, double x, double y, GtkUIManager *UIManager)
{
	m_pObject = pObject;
	m_pView = pView;
	m_pWidget = m_pView->GetWidget();
	m_pData = (gcpWidgetData*)g_object_get_data(G_OBJECT(m_pWidget), "data");
	m_pGroup = gnome_canvas_root(GNOME_CANVAS(m_pWidget));
	m_pBackground = m_pView->GetBackground();
	m_dZoomFactor = m_pView->GetZoomFactor();
	m_x = x;
	m_y = y;
	bool res = OnRightButtonClicked (UIManager);
	m_pObject = NULL;
	return res;
}

bool gcpTool::Activate(bool bState)
{
	if (bState)
	{
		m_pGroup = NULL;
		m_pBackground = NULL;
		m_pObject = NULL;
		m_pWidget = NULL;
		m_pView = NULL;
		Activate();
		return true;
	}
	else
	{
		if (Deactivate())
		{
			m_pGroup = NULL;
			m_pBackground = NULL;
			m_pObject = NULL;
			m_pWidget = NULL;
			m_pView = NULL;
			return true;
		}
		return false;
	}
}

bool gcpTool::OnClicked()
{
	return false;
}

void gcpTool::OnDrag()
{
}

void gcpTool::OnRelease()
{
}

bool gcpTool::OnRightButtonClicked(GtkUIManager *UIManager)
{
	return false;
}

void gcpTool::OnChangeState()
{
	if (m_bPressed)
	{
		m_x = lastx;
		m_y = lasty;
		OnDrag();
	}
}

void gcpTool::Activate()
{
}

bool gcpTool::Deactivate()
{
	return true;
}

void gcpTool::SetOptions()
{
}

bool gcpTool::OnEvent(GdkEvent* event)
{
	return false;
}

bool gcpTool::NotifyViewChange()
{
	return true;
}

bool gcpTool::DeleteSelection()
{
	return false;
}

bool gcpTool::CopySelection(GtkClipboard *clipboard)
{
	return false;
}

bool gcpTool::CutSelection(GtkClipboard *clipboard)
{
	return false;
}

bool gcpTool::PasteSelection(GtkClipboard *clipboard)
{
	return false;
}

bool gcpTool::OnReceive(GtkClipboard *clipboard, GtkSelectionData *data, int type)
{
	return false;
}

bool gcpTool::OnUndo()
{
	return false;
}

bool gcpTool::OnRedo()
{
	return false;
}

void gcpTool::PushNode(xmlNodePtr node)
{
}

void gcpTool::AddSelection(gcpWidgetData* data)
{
}
