// -*- C++ -*-

/* 
 * GChemPaint library
 * reaction-arrow.h 
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_REACTION_ARROW_H
#define GCHEMPAINT_REACTION_ARROW_H

#include "arrow.h"

class gcpReactionStep;
class gcpReaction;

class gcpReactionArrow: public gcpArrow
{
public:
	gcpReactionArrow (gcpReaction* react, unsigned Type = gcpSimpleArrow);
	virtual ~gcpReactionArrow ();
	
	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	virtual void Add (GtkWidget* w);
	virtual void Update (GtkWidget* w);
	void SetStartStep (gcpReactionStep *Step) {m_Start = Step;}
	gcpReactionStep* GetStartStep () {return m_Start;}
	void SetEndStep (gcpReactionStep *Step) {m_End = Step;}
	gcpReactionStep* GetEndStep () {return m_End;}
	void RemoveStep (gcpReactionStep *Step);

private:
	unsigned m_Type;
	bool m_TypeChanged;
	gcpReactionStep *m_Start, *m_End;
};

#endif	//	GCHEMPAINT_REACTION_ARROW_H
