// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomer.h 
 *
 * Copyright (C) 2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_MESOMER_H
#define GCHEMPAINT_MESOMER_H

#include <gcu/object.h>
#include <map>

using namespace std;
using namespace gcu;

extern TypeId MesomerType;

class gcpMesomery;
class gcpMesomeryArrow;
class gcpMolecule;

class gcpMesomer: public Object
{
public:
	gcpMesomer ();
	virtual ~gcpMesomer ();
	
	gcpMesomer (gcpMesomery *mesomery, gcpMolecule *molecule) throw (std::invalid_argument);
	void AddArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer) throw (std::invalid_argument);
	bool Validate () {return Arrows.size () > 0;}
	map<gcpMesomer *, gcpMesomeryArrow *> *GetArrows () {return &Arrows;}

private:
	gcpMolecule *Molecule;
	map<gcpMesomer *, gcpMesomeryArrow *> Arrows;
};

#endif	//GCHEMPAINT_MESOMER_H
