// -*- C++ -*-

/* 
 * GChemPaint arrows plugin
 * retrosynthesis.h 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_RETROSYNTHESIS_H
#define GCHEMPAINT_RETROSYNTHESIS_H

#include <gcu/object.h>

using namespace gcu;

extern TypeId RetrosynthesisType;

class gcpRetrosynthesisStep;

class gcpRetrosynthesis: public Object
{
public:
	gcpRetrosynthesis ();
	virtual ~gcpRetrosynthesis ();
	
	virtual void Add (GtkWidget* w);
	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	virtual bool Build (list<Object*>& Children) throw (invalid_argument);
	virtual double GetYAlign ();
	virtual bool BuildContextualMenu (GtkUIManager *UIManager, Object *object);
	virtual bool OnSignal (SignalId Signal, Object *Child);
	int Validate (bool split);
	void Align ();

private:
	gcpRetrosynthesis (Object* parent, gcpRetrosynthesisStep *step);

private:
	gcpRetrosynthesisStep *Target;
};

#endif	// GCHEMPAINT_RETROSYNTHESIS_H
