// -*- C++ -*-

/* 
 * GChemPaint library
 * reaction-step.h 
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_REACTION_STEP_H
#define GCHEMPAINT_REACTION_STEP_H

#include <gcu/object.h>
#include <set>

using namespace gcu;

class gcpReaction;
class gcpReactionArrow;

extern TypeId ReactionStepType;

class gcpReactionStep: public Object
{
public:
	gcpReactionStep ();
	virtual ~gcpReactionStep ();

	gcpReactionStep (gcpReaction *reaction, map<double, Object*>& Children, map<Object*, ArtDRect> Objects);

	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	virtual double GetYAlign ();
	virtual bool OnSignal (SignalId Signal, Object *Child);

	void AddArrow (gcpReactionArrow *arrow) {m_Arrows.insert (arrow);}
	void RemoveArrow (gcpReactionArrow *arrow);

private:
	bool m_bLoading;
	set<gcpReactionArrow *> m_Arrows;
};

#endif	//	GCHEMPAINT_REACTION_STEP_H
