// -*- C++ -*-

/* 
 * GChemPaint library
 * operation.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "operation.h"
#include "document.h"

xmlDocPtr pXmlDoc = xmlNewDoc((const xmlChar*)"1.0");//Needed to create xmlNodes

gcpOperation::gcpOperation(gcpDocument* pDoc)
{
	m_pDoc = pDoc;
}

gcpOperation::~gcpOperation()
{
	if (m_Nodes) delete[] m_Nodes;
}

void gcpOperation::Undo(){}
void gcpOperation::Redo(){}

void gcpOperation::Add(unsigned type)
{
	m_pDoc->LoadObjects(m_Nodes[type]);
}

void gcpOperation::Delete (unsigned type)
{
	xmlNodePtr node = m_Nodes[type]->children, child;
	char* Id;
	while (node)
	{
		Id = (strcmp ((const char*) node->name, "object"))?
			 (char*) xmlGetProp (node, (xmlChar*) "id"):
			 (char*) xmlGetProp (node->children, (xmlChar*) "id");
		m_pDoc->Remove (Id);
		xmlFree (Id);
		node = node->next;
	}
}

void gcpOperation::AddObject(Object* pObject, unsigned type)
{
	xmlNodePtr node = pObject->Save(pXmlDoc);
	if (node) xmlAddChild(m_Nodes[type], node);
}

void gcpOperation::AddNode(xmlNodePtr node, unsigned type)
{
	if (node) xmlAddChild(m_Nodes[type], node);
}

gcpAddOperation::gcpAddOperation(gcpDocument* pDoc): gcpOperation(pDoc)
{
	m_Nodes = new xmlNodePtr[1];
	*m_Nodes = xmlNewDocNode(pXmlDoc, NULL, (const xmlChar*)"add", NULL);
}

gcpAddOperation::~gcpAddOperation()
{
	if (*m_Nodes) xmlFreeNode(*m_Nodes);
}

void gcpAddOperation::Undo()
{
	Delete();
}

void gcpAddOperation::Redo()
{
	Add();
}

gcpDeleteOperation::gcpDeleteOperation(gcpDocument* pDoc): gcpOperation(pDoc)
{
	m_Nodes = new xmlNodePtr[1];
	*m_Nodes = xmlNewDocNode(pXmlDoc, NULL, (const xmlChar*)"delete", NULL);
}

gcpDeleteOperation::~gcpDeleteOperation()
{
	if (*m_Nodes) xmlFreeNode(*m_Nodes);
}

void gcpDeleteOperation::Undo()
{
	Add();
}

void gcpDeleteOperation::Redo()
{
	Delete();
}

gcpModifyOperation::gcpModifyOperation(gcpDocument* pDoc): gcpOperation(pDoc)
{
	m_Nodes = new xmlNodePtr[2];
	m_Nodes[0] = xmlNewDocNode(pXmlDoc, NULL, (const xmlChar*)"before", NULL);
	m_Nodes[1] = xmlNewDocNode(pXmlDoc, NULL, (const xmlChar*)"after", NULL);
}

gcpModifyOperation::~gcpModifyOperation()
{
	if (!m_Nodes) return;
	if (m_Nodes[0]) xmlFreeNode(m_Nodes[0]);
	if (m_Nodes[1]) xmlFreeNode(m_Nodes[1]);
}

void gcpModifyOperation::Undo()
{
	Delete(1);
	Add(0);
}

void gcpModifyOperation::Redo()
{
	Delete(0);
	Add(1);
}
