// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomer.cc
 *
 * Copyright (C) 2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "mesomer.h"
#include "mesomery.h"
#include "molecule.h"
#include "document.h"

TypeId MesomerType;

gcpMesomer::gcpMesomer (): Object (MesomerType)
{
}

gcpMesomer::~gcpMesomer ()
{
	GetParent ()->GetParent ()->AddChild (Molecule);
}

gcpMesomer::gcpMesomer (gcpMesomery* mesomery, gcpMolecule* molecule) throw (std::invalid_argument): Object (MesomerType)
{
	if (!mesomery || !molecule)
		throw invalid_argument ("NULL argument to gcpMesomer constructor!");
	SetId ("ms1");
	mesomery->AddChild (this);
	GetDocument ()->EmptyTranslationTable();
	AddChild (molecule);
	Molecule = molecule;
}

void gcpMesomer::AddArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer) throw (std::invalid_argument)
{
	if (Arrows[mesomer])
		throw invalid_argument (_("Only one arrow can link two given mesomers."));
	Arrows[mesomer] = arrow;
}
