// -*- C++ -*-

/* 
 * GChemPaint library
 * electron.h
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_ELECTRON_H
#define GCHEMPAINT_ELECTRON_H

#include <gcu/object.h>

using namespace gcu;

class gcpAtom;

extern TypeId ElectronType;

class gcpElectron: public Object
{
public:
	gcpElectron (gcpAtom *pAtom, bool IsPair);
	~gcpElectron ();

	bool IsPair () {return m_IsPair;}
	char GetPosition (double *angle, double *distance);
	void SetPosition (char Pos, double angle = 0., double distance = 0.);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual void SetSelected(GtkWidget* w, int state);
	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	virtual bool OnSignal (SignalId Signal, Object *Child);

private:
	gcpAtom* m_pAtom;
	bool m_IsPair;
	char m_Pos;
	double m_Angle, m_Dist;
};
#endif	// GCHEMPAINT_ELECTRON_H
