// -*- C++ -*-

/* 
 * GChemPaint libray
 * text-object.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_TEXT_OBJECT_H
#define GCHEMPAINT_TEXT_OBJECT_H

#include <gcu/object.h>

using namespace gcu;

class gcpTextObject: public Object
{
public:
	gcpTextObject(TypeId Type);
	gcpTextObject(double x, double y, TypeId Type);
	virtual ~gcpTextObject();
	
	const GtkTextBuffer* GetTextBuffer() {return m_buf;}
	void GetSize(double& x, double& y) {x = m_length; y = m_height;}
	xmlNodePtr SaveSelected();
	void LoadSelected(xmlNodePtr node);
	virtual bool OnChanged(GtkTextBuffer *textbuffer) = 0;
	virtual bool OnMarkSet(GtkTextBuffer *textbuffer, GtkTextIter *iter, GtkTextMark *mark) = 0;
	virtual bool OnInsertText(GtkTextBuffer *textbuffer, GtkTextIter *iter, gchar* newtext, gint length) = 0;
	virtual bool OnEndUserAction(GtkTextBuffer *textbuffer) = 0;
	virtual bool SaveNode(xmlDocPtr xml, xmlNodePtr);
	virtual bool Load(xmlNodePtr);
	virtual void Move(double x, double y, double z = 0);
	bool IsLocked() {return m_bLoading;}

protected:
	double m_x, m_y, m_length, m_height;
	int m_ascent;
	int m_InsertOffset;
	GtkTextBuffer* m_buf;
	bool m_bLoading;
};


#endif	//GCHEMPAINT_TEXT_OBJECT_H
