// -*- C++ -*-

/* 
 * GChemPaint library
 * mendeleiev.cc 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include <glade/glade.h>
#include "mendeleiev.h"
#include "application.h"
#include <gcu/element.h>

static void on_element(GtkWidget *widget, guint Z, gcpMendeleievDlg *pBox)
{
	pBox->OnElement(Z);
}

gcpMendeleievDlg::gcpMendeleievDlg(gcpApplication* App, int Z): gcpDialog(App, DATADIR"/gchempaint/ui/mendeleiev.glade", "mendeleiev")
{
	GtkWidget* frame = glade_xml_get_widget(xml, "frame");
	periodic = (GtkPeriodic*)gtk_periodic_new();
	gtk_container_add(GTK_CONTAINER(frame), (GtkWidget*)periodic);
	gtk_widget_show_all(frame);
	App->SetCurZ(Z);
	gtk_periodic_set_element(periodic, Z);
	g_signal_connect(G_OBJECT(periodic), "element_changed", G_CALLBACK(on_element), this);
	App->ActivateMenu("Mendeleiev", true);
	App->SetDialog("Mendeleiev", this);
	gtk_widget_show(GTK_WIDGET(dialog));
	apply = NULL;
}

gcpMendeleievDlg::~gcpMendeleievDlg()
{
	m_App->ToggleMenu("Mendeleiev", false);
	m_App->SetDialog("Mendeleiev", NULL);
}

void gcpMendeleievDlg::OnElement(int Z)
{
	m_App->SetCurZ(Z);
	if (apply) apply(m_data, Z);
	SetElement (m_App, Z);
}

void gcpMendeleievDlg::SetCallBack(void (*f)(void*, int), void* data)
{
	apply = f;
	m_data = data;
}

void gcpMendeleievDlg::SetElement (gcpApplication* App, int Z)
{
	GtkWidget* w = App->GetToolItem("Element");
	if (!w) return;
	GtkWidget* icon = gtk_tool_button_get_icon_widget (GTK_TOOL_BUTTON (w));
	if (!GTK_IS_LABEL (icon))
	{
		icon = gtk_label_new(Element::Symbol(Z));
		gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (w), icon);
		gtk_widget_show_all (w);
	}
	else gtk_label_set_text (GTK_LABEL (icon), Element::Symbol(Z));
}
