// -*- C++ -*-

/* 
 * GChemPaint
 * standaloneapp.h
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
 
#ifndef GCHEMPAINT_STANDALONEAPP_H
#define GCHEMPAINT_STANDALONEAPP_H

#include "lib/application.h"
#include "lib/document.h"

class gcpStandaloneApp: public gcpApplication
{
public:
	gcpStandaloneApp();
	virtual ~gcpStandaloneApp();

	virtual void ActivateMenu(const string& menuname, bool activate);
//	virtual void ActivateTool(const string& toolname, bool activate);
	virtual void ActivateToolItem(const string& itemname, bool activate);
	virtual void ClearStatus();
	virtual void SetStatusText(const char* text);
	virtual GtkWindow* GetWindow();
	virtual void RemoveDocument(gcpDocument* pDoc);
	void OnFileNew();
	void OnSave();
	void OnFileOpen();
	void OnToolClicked (GtkWidget* widget);
	void OnDoubleClick(GtkWidget* widget);
	void OnRightClick(GtkWidget* widget);
	bool OnKeyPressed(GtkWidget* widget, GdkEventKey* ev);
	bool OnKeyReleased(GtkWidget* widget, GdkEventKey* ev);
	void OnProperties();
	void OnPrint();
	void SetActive (gcpDocument* pDoc, GtkWidget* w);
	void OnFileClose ();
	void OnUndo();
	void OnRedo();
	void OnSelectAll();
	void OnPasteSelection();
	void OnCutSelection();
	void OnCopySelection();
	void OnDeleteSelection();

protected:
	virtual void AddDocument(gcpDocument* pDoc);

private:
	GtkWidget* CreateView();
	void AppendUI (BonoboUINode* Node);
	void AddToolbar (BonoboUINode* Node);

private:
	GnomeApp* m_App;
	GtkNotebook* m_Book;
	GtkWidget* m_Bar;	//GnomeAppBar
	gint m_NumWindow;
	map <string, GtkRadioToolButton*> Groups;
};

#endif //GCHEMPAINT_STANDALONEAPP_H
