// -*- C++ -*-

/* 
 * GChemPaint
 * fragment-atom.cc 
 *
 * Copyright (C) 2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "fragment-atom.h"
#include "fragment.h"
#include "molecule.h"
#ifdef GCU_OLD_VER
#	include <chemistry/element.h>
#else
#	include <gcu/element.h>
#endif

gcpFragmentAtom::gcpFragmentAtom(): gcpAtom()
{
	SetId("a1");
}

gcpFragmentAtom::gcpFragmentAtom(gcpFragment *fragment, int Z): gcpAtom()
{
	m_Fragment = fragment;
	SetZ(Z);
	SetId("a1");
}

gcpFragmentAtom::~gcpFragmentAtom() {}

void gcpFragmentAtom::SetZ(int Z)
{
	static bool setting = false;
	if (setting) return;
	setting = true;
	Atom::SetZ(Z);
	if (Z != 0) m_Fragment->OnChangeAtom();
	setting = false;
}

/*!
Only accept a new bond if none exists. So only one bond.
*/
bool gcpFragmentAtom::AcceptNewBonds(int nb)
{
	return (nb > 1)? false: GetBondsNumber() == 0;
}

/*!
Overrided to avoid gcpAtom::Add execution. Don't do anything.
*/
void gcpFragmentAtom::Add(GtkWidget* w)
{
}

/*!
Overrided to avoid gcpAtom::Update execution. Just call fragment Update method.
*/
void gcpFragmentAtom::Update(GtkWidget* w)
{
	m_Fragment->Update(w);
}


/*!
Overrided to avoid gcpAtom::SetSelected execution. Just call fragment SetSelected method.
*/
void gcpFragmentAtom::SetSelected(GtkWidget* w, int state)
{
	m_Fragment->SetSelected(w, state);
}

xmlNodePtr gcpFragmentAtom::Save(xmlDocPtr xml)
{
	xmlNodePtr node;
	gchar buf[16];
	node = xmlNewDocNode(xml, NULL, (xmlChar*)"atom", NULL);
	if (!node) return NULL;
	SaveId(node);

	strncpy(buf, GetSymbol(), sizeof(buf));
	xmlNodeSetContent(node, (xmlChar*)buf);
	
	if (m_Charge)
	{
		snprintf(buf, sizeof(buf), "%d", m_Charge);
		xmlNewProp(node, (xmlChar*)"charge", (xmlChar*)buf);
	}
	return node;
}

bool gcpFragmentAtom::Load(xmlNodePtr node)
{
	char* tmp, *endptr;
	xmlNodePtr child;
	tmp = (char*)xmlGetProp(node, (xmlChar*)"id");
	if (tmp)
	{
		SetId(tmp);
		xmlFree(tmp);
	}
	tmp = (char*)xmlNodeGetContent(node);
	if (tmp)
	{
		m_Z = Element::Z(tmp);
		xmlFree(tmp);
	}
	tmp = (char*)xmlGetProp(node, (xmlChar*)"charge");
	m_Charge = (tmp)? (char)atoi(tmp): 0;
	if (tmp) xmlFree(tmp);
	return true;
}

void gcpFragmentAtom::AddToMolecule(gcpMolecule* Mol)
{
	Mol->AddFragment(m_Fragment);
}

int gcpFragmentAtom::GetChargePosition(double& x, double& y)
{
	return m_Fragment->GetChargePosition(this, x, y);
}
