// -*- C++ -*-

/* 
 * GChemPaint
 * tools.cc 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "tools.h"
#include "tool.h"
#include <chemistry/element.h>
#include "globals.h"
#include "gchempaint-bonobo.h"

extern int CurElt;

static void on_clicked(GtkWidget *widget, void * data)
{
	gcpToolsDlg* pBox = (gcpToolsDlg*)data;
	pBox->Select(widget);
}

static bool on_tools_event(GtkWidget *widget, GdkEvent *event, gcpToolsDlg* dlg)
{
	if (event->type == GDK_2BUTTON_PRESS)
	{
		dlg->OnDoubleClick(widget);
		return true;
	}
	else if ((event->type == GDK_BUTTON_PRESS) && (event->button.button == 3))
	{
		dlg->OnRightClick(widget);
	}
	return false;
}

void on_show_tools(GtkWidget* widget, void* data)
{
	if (ToolsDlg) ToolsDlg->Destroy();
	else
	{
		ToolsDlg = new gcpToolsDlg();
		ToolsDlg->SetElement(CurElt);
	}
}

gcpToolsDlg* ToolsDlg;
GtkCheckMenuItem* ToolsMenu;

gcpToolsDlg::gcpToolsDlg():gcpDialog(DATADIR"/gchempaint/glade/tools.glade", "bonds")
{
	ToolsDlg = this;
	int Id;
	char buf[16];
	GtkWidget* button;
	for (Id = 0; Id < (int)MaxId; Id++)
	{
		snprintf(buf, sizeof(buf), "btn%d", Id);
		button = glade_xml_get_widget(xml, buf);
		if (button)
		{
			if ((!pActiveTool && (Id == 0)) || (pActiveTool == Tools[Id]))
			{
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), true);
				m_button = GTK_WIDGET(button);
			}
			else if (Id == ElementId) m_element = GTK_WIDGET(button);
			g_signal_connect(G_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_clicked), this);
			g_signal_connect(G_OBJECT(button), "event", GTK_SIGNAL_FUNC(on_tools_event), this);
		}
		else Tools[Id] = NULL;
	}
	if (!pActiveTool)
		pActiveTool = Tools[0];
	if (!IsEmbedded()) ToolsMenu->active = true;
}

gcpToolsDlg::~gcpToolsDlg()
{
	if (!IsEmbedded()) ToolsMenu->active = false;
	else gcp_bonobo_set_state(NULL, "/commands/ViewTools", "0");
	ToolsDlg = NULL;
}

void gcpToolsDlg::Select(GtkWidget* widget)
{
	static bool bChanging = false;
	if ((widget != m_button) && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
	{
		bChanging = true;
		if (pActiveTool && !pActiveTool->Activate(false))
		{
			bChanging = false;
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), false);
			return;
		}
		if (m_button) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_button), false);
		m_button = widget;
		const gchar* name = gtk_widget_get_name(widget);
		gcpToolId ToolId = (gcpToolId) atoi(name + 3);
		pActiveTool = Tools[ToolId];
		if (pActiveTool) pActiveTool->Activate(true);
		else
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_button), false);
			m_button = NULL;
		}
	}
	else
	{
		if (bChanging)
		{
			m_button = NULL;
			if (pActiveTool) pActiveTool->Activate(false);
			pActiveTool = NULL;
			bChanging = false;
		}
		else if (pActiveTool) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_button), true);
	}
}

void gcpToolsDlg::Select(gcpToolId Id)
{
	char buf[16];
	GtkWidget* button;
	snprintf(buf, sizeof(buf), "btn%d", Id);
	button = glade_xml_get_widget(xml, buf);
	if (button) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), true);
}

void gcpToolsDlg::OnDoubleClick(GtkWidget* widget)
{
	const gchar* name = gtk_widget_get_name(widget);
	gcpToolId ToolId = (gcpToolId) atoi(name + 3);
	if (Tools[ToolId]) Tools[ToolId]->SetOptions();
}

void gcpToolsDlg::OnRightClick(GtkWidget* widget)
{
	const gchar* name = gtk_widget_get_name(widget);
	gcpToolId ToolId = (gcpToolId) atoi(name + 3);
	if (Tools[ToolId]) Tools[ToolId]->SetOptions();
}

void gcpToolsDlg::SetElement(int Z)
{
	GtkLabel* label = GTK_LABEL(GTK_BIN(m_element)->child);
	if (Z) gtk_label_set_text(label, gcu::Element::Symbol(Z));
	else gtk_label_set_text(label, "");
}
