// -*- C++ -*-

/* 
 * GChemPaint
 * dialog.h 
 *
 * Copyright (C) 2001-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "dialog.h"
#include "globals.h"
#include <string.h>

static void on_OK(GtkWidget *widget, gcpDialog* pBox)
{
	pBox->Apply();
	pBox->Destroy();
}

static void on_apply(GtkWidget *widget, gcpDialog* pBox)
{
	pBox->Apply();
}

static void on_cancel(GtkWidget *widget, gcpDialog* pBox)
{
	pBox->Destroy();
}

static void on_help(GtkWidget *widget, gcpDialog* pBox)
{
	pBox->Help();
}

static bool on_destroy(GtkWidget *widget, gcpDialog* pBox)
{
	delete pBox;
	return true;
}

gcpDialog::gcpDialog(const char* filename, const char* windowname, void (*extra_destroy)(gpointer), gpointer data)
{
	xml =  glade_xml_new(filename, windowname, NULL);
	m_extra_destroy = extra_destroy;
	m_windowname = g_strdup(windowname);
	m_data = data;
	if (xml)  glade_xml_signal_autoconnect (xml);
	dialog = GTK_WINDOW(glade_xml_get_widget(xml, windowname));
	SET_ICON(dialog);
	g_signal_connect(G_OBJECT(dialog), "destroy", G_CALLBACK(on_destroy), this);
	GtkWidget* button = glade_xml_get_widget(xml, "OK");
	if (button) g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_OK), this);
	button = glade_xml_get_widget(xml, "apply");
	if (button) g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_apply), this);
	button = glade_xml_get_widget(xml, "cancel");
	if (button) g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_cancel), this);
	button = glade_xml_get_widget(xml, "help");
	if (button) g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_help), this);
}

gcpDialog::~gcpDialog()
{
	g_free(m_windowname);
	g_object_unref(G_OBJECT(xml));
}

void gcpDialog::Destroy()
{
	if (m_extra_destroy) m_extra_destroy(m_data);
	gtk_widget_destroy(GTK_WIDGET(dialog));
}

bool gcpDialog::Apply()
{
	return true;
}

void gcpDialog::Help()
{
	gchar *tag = g_strdup_printf("%s-%s", PACKAGE, m_windowname);
	
	gnome_help_display(PACKAGE, tag, NULL);
	g_free(tag);
}

bool gcpDialog::GetNumber(GtkEntry *Entry, double *x, gcpCheckType c, double min, double max)
{
	const gchar* text = gtk_entry_get_text (Entry);
	char *end;
	*x = strtod(text, &end);
	if (end != text + strlen(text))
	{
		gtk_window_set_focus(GTK_WINDOW(dialog), GTK_WIDGET(Entry));
		GtkDialog* box = GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_MODAL,
										GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _("Type a number")));
		SET_ICON(box);
		gtk_dialog_run(box);
		return false;
	}
	switch (c)
	{
	case gcpMinEqMax:
		if ((*x < min) || (*x >= max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GtkDialog* box = GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, m_buf));
			SET_ICON(box);
			gtk_dialog_run(box);
			return false;
		}
		break;
	case gcpMinEqMaxEq:
		if ((*x < min) || (*x > max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GtkDialog* box = GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, m_buf));
			SET_ICON(box);
			gtk_dialog_run(box);
			return false;
		}
		break;
	case gcpMinMax:
		if ((*x <= min) || (*x >= max))
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number between %g and %g"), min, max);
			GtkDialog* box = GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, m_buf));
			SET_ICON(box);
			gtk_dialog_run(box);
			return false;
		}
		break;
	case gcpMin:
		if (*x < min)
		{
			snprintf(m_buf, sizeof(m_buf), _("Type a number greater than %g"), min);
			GtkDialog* box = GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, m_buf));
			SET_ICON(box);
			gtk_dialog_run(box);
			return false;
		}
		break;
	default:
		break;
	}
	return true;
}
