// -*- C++ -*-

/* 
 * GChemPaint
 * globals.h 
 *
 * Copyright (C) 2001-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
#include <gtk/gtkwidget.h>

bool IsEmbedded();
void clear_status();
void set_status_text(const char* status);
void ActivateMenu(int menu, int menuitem, bool activate);
void ActivateTool(int tool, bool activate);
enum
{
	NewMenu,
	OpenMenu,
	SaveMenu,
	SaveAsMenu,
	SaveAsImageMenu
};
enum
{
	UndoMenu,
	RedoMenu,
	SeparatorMenu,
	CutMenu,
	CopyMenu,
	PasteMenu,
	EraseMenu
};
enum
{
	FileMenu,
	EditMenu
};
enum
{
	NewTool,
	OpenTool,
	SaveTool,
	CloseTool,
	PrintTool,
	QuitTool
};
//Text tools bar
extern GtkWidget	*TextToolBar, *BoldBtn, *ItalicBtn, *UnderlineBtn, *StrikethroughBtn,
									*SubscriptBtn, *SuperscriptBtn, *FontBtn;

#ifdef GTK_IS_26
#define SET_ICON(w) gtk_window_set_icon_name (GTK_WINDOW (w), "gchempaint")
#else
extern GdkPixbuf *icon;
#define SET_ICON(w) gtk_window_set_icon (GTK_WINDOW (w), icon)
#endif
