// -*- C++ -*-

/* 
 * GChemPaint
 * texttool.h 
 *
 * Copyright (C) 2002-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_TEXT_TOOL_H
#define GCHEMPAINT_TEXT_TOOL_H

#include "tool.h"
#include <list>

using namespace std;

class gcpTextTool: public gcpTool
{
public:
	gcpTextTool(gcpToolId Id = TextId);
	virtual ~gcpTextTool();

	virtual bool OnClicked();
	virtual bool Deactivate();
	virtual void Activate();
	virtual bool OnEvent(GdkEvent* event);
	virtual bool NotifyViewChange();
	bool OnToggled(GtkToggleButton *btn);
	bool OnFont();
	virtual bool DeleteSelection();
	virtual bool CopySelection(GtkClipboard *clipboard);
	virtual bool CutSelection(GtkClipboard *clipboard);
	virtual bool PasteSelection(GtkClipboard *clipboard);
	virtual bool OnReceive(GtkClipboard *clipboard, GtkSelectionData *data, int type);
	virtual bool OnUndo();
	virtual bool OnRedo();
	void PushNode(xmlNodePtr node);

protected:
	virtual bool Unselect();

protected:
	GnomeCanvasRichTextExt* m_Active;
	list<xmlNodePtr> m_UndoList, m_RedoList;
	xmlNodePtr m_CurNode, m_InitNode;

private:
	bool m_bUndo;
};

extern gcpTextTool TextTool;

#endif	//GCHEMPAINT_TEXT_TOOL_H
