// -*- C++ -*-

/* 
 * GChemPaint
 * reaction.h 
 *
 * Copyright (C) 2002-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_REACTION_H
#define GCHEMPAINT_REACTION_H

#include "molecule.h"
#include "arrowtool.h"
#include "arrow.h"

class gcpReaction;

class gcpReactant: public gcpMolecule
{
public:
	gcpReactant();
	virtual ~gcpReactant();
	
	
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	unsigned GetStep() {return m_Step;}
	void SetStep(unsigned Step) {m_Step = Step;}

private:
	unsigned m_Step; //0 for reactants, 1 for products of first step, 2 for second step,...
	unsigned m_Stoech;	//always positive
};

class gcpReactionOperator: public Object
{
public:
	gcpReactionOperator(gcpReaction* react, unsigned Step = 0);
	virtual ~gcpReactionOperator();
	
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual void Move(double x, double y, double z = 0);
	virtual void SetSelected(GtkWidget* w, int state);
	unsigned GetStep() {return m_Step;}
	void SetStep(unsigned Step) {m_Step = Step;}
	void SetCoords(double x, double y);
	bool GetCoords(double* x, double* y);
	
private:
	unsigned m_Step;
	double m_x, m_y;
};

class gcpReactionArrow: public gcpArrow
{
public:
	gcpReactionArrow(gcpReaction* react, gcpArrowType Type = gcpSimpleArrow, unsigned Step = 0);
	virtual ~gcpReactionArrow();
	
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	
private:
	gcpArrowType m_Type;
	bool m_TypeChanged;
};

class gcpReaction: public Object
{
public:
	gcpReaction();
	virtual ~gcpReaction();
	
	virtual void Add(GtkWidget* w);
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
};

#endif	//GCHEMPAINT_REACTION_H
