// -*- C++ -*-

/* 
 * GChemPaint
 * mendeleiev.cc 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "globals.h"
#include "gchempaint-bonobo.h"
#include <libgnome/libgnome.h>
#include <glade/glade.h>
#include "mendeleiev.h"
#include <chemistry/element.h>

int CurZ = 6;

static void on_element(GtkWidget *widget, guint Z, gcpMendeleievDlg *pBox)
{
	pBox->OnElement(Z);
}

gcpMendeleievDlg *MendeleievDlg = NULL;
GtkCheckMenuItem* MendeleievMenu;

gcpMendeleievDlg::gcpMendeleievDlg(int Z): gcpDialog(DATADIR"/gchempaint/glade/mendeleiev.glade", "mendeleiev")
{
	GtkWidget* frame = glade_xml_get_widget(xml, "frame");
	periodic = (GtkPeriodic*)gtk_periodic_new();
	gtk_container_add(GTK_CONTAINER(frame), (GtkWidget*)periodic);
	gtk_widget_show_all(frame);
	gtk_periodic_set_element(periodic, CurZ = Z);
	g_signal_connect(G_OBJECT(periodic), "element_changed", G_CALLBACK(on_element), this);
	if (IsEmbedded()) gcp_bonobo_set_state(NULL, "/commands/ViewElements", "1");
	else MendeleievMenu->active = true;
	MendeleievDlg = this;
	gtk_widget_show(GTK_WIDGET(dialog));
}

gcpMendeleievDlg::~gcpMendeleievDlg()
{
	if (IsEmbedded()) gcp_bonobo_set_state(NULL, "/commands/ViewElements", "0");
	else MendeleievMenu->active = false;
	MendeleievDlg = NULL;
}

void gcpMendeleievDlg::OnElement(int Z)
{
	CurZ = Z;
	if (apply) apply(Z);
}

void gcpMendeleievDlg::SetCallBack(void (*f)(int))
{
	apply = f;
}
