// -*- C++ -*-

/* 
 * GChemPaint
 * fragmenttool.cc 
 *
 * Copyright (C) 2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "plustool.h"
#include "reaction.h"
#include "settings.h"
#include "document.h"
#include "libgcpcanvas/gcp-canvas-group.h"
#include <chemistry/object.h>

using namespace gcu;

static Object* CreatePlusSign()
{
	return new gcpReactionOperator(NULL);
}

gcpPlusTool PlusTool;

gcpPlusTool::gcpPlusTool(): gcpTool(PlusSignId)
{
	Object::AddType("reaction-operator", CreatePlusSign, ReactionOperatorType);
	m_bChanged = false;
}

gcpPlusTool::~gcpPlusTool()
{
}

bool gcpPlusTool::OnClicked()
{
	if (m_pObject) return false;
	m_bChanged = true;
	const gchar* symbol = "+";
	PangoLayout* pl = pango_layout_new(m_pView->GetPangoContext());
	pango_layout_set_text(pl, symbol, 1);
	gint width = pango_layout_get_width(pl);
	m_x1 = m_x0 - (double)width / 2 - m_pData->Padding;
	m_y1 = m_y0 - m_pView->GetFontHeight() / 2 - m_pData->Padding;
	m_x2 = m_x0 + (double)width / 2 + m_pData->Padding;
	m_y2 = m_y0 + m_pView->GetFontHeight() / 2 + m_pData->Padding;
	m_pItem = gnome_canvas_item_new(m_pGroup, gnome_canvas_group_ext_get_type(), NULL);
	gnome_canvas_item_new(
					(GnomeCanvasGroup*)m_pItem,
					gnome_canvas_rect_get_type(),
					"x1", m_x1,
					"y1", m_y1,
					"x2", m_x2,
					"y2", m_y2,
					"fill_color", "white",
					NULL);
	gnome_canvas_item_new(
					(GnomeCanvasGroup*)m_pItem,
					gnome_canvas_text_get_type(),
					"text", symbol,
					"x", rint(m_x0),
					"y", rint(m_y0),
					"font", m_pView->GetFontName(),
					"anchor", GTK_ANCHOR_CENTER,
					"fill_color", AddColor,
					NULL);
	return true;
}

void gcpPlusTool::OnDrag()
{
	if ((m_x > m_x1) && (m_x2 > m_x) && (m_y > m_y1) && (m_y2 > m_y))
	{
		if (!m_bChanged)
		{
			gnome_canvas_item_show(m_pItem);
			m_bChanged = true;
		}
	}
	else if (m_bChanged)
	{
		gnome_canvas_item_hide(m_pItem);
		m_bChanged = false;
	}
}

void gcpPlusTool::OnRelease()
{
	if (m_bChanged)
	{
		gcpReactionOperator* pOp = new gcpReactionOperator(NULL);
		pOp->SetCoords(m_x0 / m_pData->ZoomFactor, m_y0 / m_pData->ZoomFactor);
		m_pView->GetDoc()->AddObject(pOp);
		m_pView->GetDoc()->FinishOperation();
	}
}
