# Gash --- Guile As SHell
# Copyright © 2016, 2017 R.E.W. van Beusekom <rutger.van.beusekom@gmail.com>
# Copyright © 2018 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
# Copyright © 2018, 2019 Timothy Sample <samplet@ngyro.com>
#
# This file is part of Gash.
#
# Gash is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# Gash is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Gash.  If not, see <http://www.gnu.org/licenses/>.

set -e
if [ -n "$V" ]; then
    set -x
fi
DIFF=${DIFF-diff}
TEST_SHELL=${TEST_SHELL-gash}

t="$1"
s=tests/$(basename "$t" .sh)

# This is a hack to make sure we can build from an external directory.
# We move into the source directory, and then send all of our output
# back to the build directory.
export TEST_TMP=$(pwd)
b=$(pwd)/$s
cd $(dirname "$t")/..

set +e
timeout 10 $TEST_SHELL -e "$s".sh -s --long file0 file1 > "$b".1 2> "$b".2
r=$?
set -e
if [ -f "$s".exit ]; then
    e=$(cat "$s".exit)
else
    e=0
fi
[ $r = $e ] || exit 1
if [ -f "$s".stdout ]; then
        $DIFF -u "$s".stdout "$b".1
fi
if [ -f "$s".stderr ]; then
    $DIFF -u "$s".stderr "$b".2
fi
