/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Neural Map Simulator
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Neural Map Simulator (0:Learn,1:Run)
void GNMS(int SimFunc)

{

    //Variables
    register int i,j;		//Fast Counters
    int n,k,p;			//Simple Counters
    int GNC;			//GNeurons Counter
    int NLH;			//Next Layer Head
    int NLE;			//Next Layer End
    int GNFT;			//GNeuron Function Type
    int RSN;			//Registration Serial Number
    int Sims;			//Simulations Number
    float NewData[MAX_PIN];	//New Data From Inputs GSocket
    float AccErr;		//Acceptable Error (%)
    float GErr;			//G.A.N.N Error (%)
    float Tmp;			//Temp Values
    FILE *FileToCheck;		//A File Pointer
    
    //Check For Wrong Simulation Mode
    if (SimFunc<0 OR SimFunc>2)
    
    {
    
        printf("Error:Wrong Simulation Mode Specified!\n");
        
        exit(1);
    
    }
    
    //Reset Registration Serial Number
    RegSerNum=0;
    RSN=0;
    
    //Learn
    if (SimFunc==0)
    
    {
    
        //Create A New G.A.N.N In Memory (G.A.N.N Matrix)
        GNeuron *GANN;
        GANN=new GNeuron[MAX_MATRIX];
        
        //Get I/O From GSockets Loaded In Memory
        Inputs=InSocket.GetPins();
        Outputs=OutSocket.GetPins();
        
        //Get Acceptable Error
        AccErr=100.0-LearnTH;
        
        //Fill NData With Inputs GSocket Data (Only For Uniform Checks)
        for (i=0;i<Inputs;i++)
            NewData[i]=InSocket.GetPV(i,0);
        
        //Check GMap Simulation Type So As To Set GNeurons Function Type
        if (GMSType==0)
            GNFT=0;
        else
            GNFT=2;
        
        //Print Inputs GSocket
        printf("----- Inputs GSocket -----\n\n");   
        
        for (i=0;i<Inputs;i++)
        
        {
        
            printf("GPin:%i\n",i+1);
            printf("Minimum Value:%.1f\n",InSocket.GetPV(i,0));
            
            if (InSocket.GetPV(i,1)==0.0)
                printf("Maximum Value:N/A\n\n");
            else
                printf("Maximum Value:%.1f\n\n",InSocket.GetPV(i,1));
        
        }
        
        printf("--------------------------\n\n");
        
        //Start Simulation
        printf("Learning...\n\n");
        
        //Simulations Loop
        for (n=0;n<SimNum;n++)
        
        {
        
            printf("* Simulation %i *\n\n",n+1);
            
            //Escape Caption
            ReRoute:;
            
            //Randomize
            GRand();
            
            //Reset GNC
            GNC=-1;
            
            //Reset NLH
            NLH=0;
            
            //Reset NLE
            NLE=0;
            
            //Start Routing Through The Layers
            for (i=0;i<Layers;i++)
            
            {
            
                //Get GNeurons Of Current Layer
                k=GMap[i];
                
                //Check GMap Connections Type (0:Auto,1:Manual)
                if (GMCType==0)
                
                {
                
                    //Enable All GNeurons In This Layer
                    for (j=NLE;j<(k+NLE);j++)
                    
                    {
                    
                        //GNeurons Counter
                        GNC++;
                        
                        //Get Data From InSocket (First Layer)
                        if (i==0)
                        
                        {
                        
                            for (p=0;p<Inputs;p++)
                            
                            {
                            
                                //Get Data Or Data Range
                                if (InSocket.GetPV(p,1)==0.0)
                                    Tmp=InSocket.GetPV(p,0);
                                else
                                    Tmp=GGenData(InSocket.GetPV(p,0),\
                                    InSocket.GetPV(p,1));
                                
                                //Give Data To This GNeuron
                                GANN[GNC].InData(p,Tmp);
                            
                            }
                        
                        }
                        
                        //Get Data From Previous Layer
                        else
                        
                        {
                        
                            for (p=NLH;p<(NLH+NLE);p++)
                            
                            {
                            
                                //Give Data To This GNeuron
                                GANN[GNC].InData(p-NLH,GANN[p].OutData());
                            
                            }
                        
                        }
                        
                        //Enable This GNeuron
                        GANN[GNC].Enable(GNFT);
                        
                        printf("GNeuron %i Enabled!\n\n",GNC+1);
                    
                    }
                    
                    //Next Layer Head
                    NLH+=NLE;
                    
                    //Next Layer End
                    NLE=k;
                
                }
                
                else
                
                {
                
                    //User Defined Connections
                    printf("Notice:No Connections Specified!\n");
                    
                    exit(0);
                
                }
            
            }
            
            //Reset j
            j=0;
            
            //Fill GData
            for (i=NLH;i<(NLH+NLE);i++)
            
            {
            
                if (OutSocket.GetPV(j,1)!=0.0)
                
                {
                
                    GMinData[j]=GANN[i].OutData()*OutSocket.GetPV(j,0);
                    GMaxData[j]=GANN[i].OutData()*OutSocket.GetPV(j,1);
                
                }
                
                else
                
                {
                
                    GMinData[j]=GANN[i].OutData()*OutSocket.GetPV(j,0);
                    GMaxData[j]=0.0;
                
                }
                
                j++;
            
            }
            
            //Gather Error Statistics (ECT - 0:Uniform,1:Non-Uniform)
            GErr=GErrStat(NewData,GMinData,GMaxData,ECT);
            
            //Check Error Statistics
            if (GErr<=AccErr)
            
            {
            
                if (RegSerNum==0)
                
                {
                
                    //Produce A Registration Serial Number
                    RegSerNum=(int)GGenData(1,\
                    ((Inputs+Outputs)*GNC*time(0))/SimNum);
                    
                    //Initialize GSims
                    FileToCheck=fopen("GSims","a");
                    
                    //Save Registration Serial Number
                    fprintf(FileToCheck,"%i\n",RegSerNum);
                    
                    //Save Simulations Number
                    fprintf(FileToCheck,"%i\n",SimNum);
                    
                    //Close GSims
                    fclose(FileToCheck);
                
                }
                
                //Save This G.A.N.N To The GKDB
                GSaveData(GANN,RegSerNum,n+1);
                
                //Print Outputs GSocket
                printf("----- Outputs GSocket -----\n\n");
                
                for (i=0;i<Outputs;i++)
                
                {
                
                    printf("GPin:%i\n",i+1);
                    printf("Min Value:%.1f\n",GMinData[i]);
                    
                    if (GMaxData[i]==0.0)
                        printf("Maximum Value:N/A\n\n");
                    else
                        printf("Max Value:%.1f\n\n",GMaxData[i]);
                
                }
                
                printf("---------------------------\n\n");
                
                printf("Learning Successfully Completed!\n\n");
            
            }
            
            else
            
            {
            
                //Error Correction
                for (i=0;i<Outputs;i++)
                
                {
                
                    printf("Error Correction [Output GPin %i]\n\n",i+1);
                    
                    for (j=0;j<GNNum;j++)
                    
                    {
                    
                        Tmp=OutSocket.GetPV(i,1);
                        
                        if (Tmp!=0.0 AND (GANN[j].OutData()*Tmp)>Tmp)
                            GErrC(GANN,j,GErr,AUTO);
                        
                        Tmp=OutSocket.GetPV(i,0);
                        
                        if (OutSocket.GetPV(i,1)==0.0 AND\
                        (GANN[j].OutData()*Tmp)>Tmp)
                            GErrC(GANN,j,GErr,AUTO);
                        
                        if ((GANN[j].OutData()*Tmp)<Tmp)
                            GErrC(GANN,j,GErr,AUTO);
                    
                    }
                
                }
                
                goto ReRoute;
            
            }
        
        }
        
        //Unload G.A.N.N From Memory
        delete []GANN;
        
        //Initialize GRegs
        FileToCheck=fopen("GRegs","a");
        
        //Save G.A.N.N Registrations
        fprintf(FileToCheck,"%i\n",RegSerNum);
        
        //Close GRegs
        fclose(FileToCheck);
    
    }
    
    //Run
    else
    
    {
    
        //Create A New G.A.N.N In Memory (G.A.N.N Matrix)
        GNeuron *GANN;
        GANN=new GNeuron[MAX_MATRIX];
        
        //Run GRMC (User Interaction - Load Offset And RegSerNum)
        GRMC();
        
        //Initialize GSims
        FileToCheck=fopen("GSims","r");
        
        //Get Simulations Number
        while ((i=feof(FileToCheck))==FALSE)
        
        {
        
            fscanf(FileToCheck,"%i\n",&RSN);
            fscanf(FileToCheck,"%i\n",&Sims);
            
            if (RegSerNum==RSN)
                break;
        
        }
        
        //Close GSims
        fclose(FileToCheck);
        
        //Reset n
        n=0;
        
        //Start Simulation
        printf("Running...\n\n");
        
        //Escape Caption
        ReRun:;
        
        //Increase Simulations Pointer
        n++;
        
        //Read GKDB
        GReadData(GANN,Offset,RegSerNum,n);
        
        //Compare User Inputs With G.A.N.N Inputs
        if (UserInp>Inputs)
        
        {
        
            printf("Error:Too Many Inputs For This Registration!\n");
            
            exit(1);
        
        }
        
	//Check GMap Simulation Type So As To Set GNeurons Function Type
	if (GMSType==0)
	    GNFT=0;
	else
	    GNFT=2;
        
        //Reset GNC
        GNC=-1;
        
        //Reset NLH
        NLH=0;
        
        //Reset NLE
        NLE=0;
        
        //Start Routing Through The Layers
        for (i=0;i<Layers;i++)
        
        {
        
            //Get GNeurons Of Current Layer
            k=GMap[i];
            
            //Check GMap Connections Type (0:Auto,1:Manual)
            if (GMCType==0)
            
            {
            
                //Enable All GNeurons
                for (j=NLE;j<(k+NLE);j++)
                
                {
                
                    //GNeurons Counter
                    GNC++;
                    
                    //Give Data To GNeurons Of The First Layer
                    if (i==0)
                    
                    {
                    
                        for (p=0;p<Inputs;p++)
                            GANN[GNC].InData(p-NLH,UserVal[p]);
                    
                    }
                    
                    else
                    
                    {
                    
                        //Give Data To GNeurons Of The Rest Layers
                        for (p=NLH;p<(NLH+NLE);p++)
                            GANN[GNC].InData(p-NLH,GANN[p].OutData());
                    
                    }
                    
                    //Run This GNeuron
                    GANN[GNC].Run(GNFT);
                
                }
                
                //Next Layer Head
                NLH+=NLE;
                
                //Next Layer End
                NLE=k;
            
            }
            
            else
            
            {
            
                //User Defined Connections
                
            
            }
        
        }
        
        //Reset j
        j=0;
        
        //Get G.A.N.N Values
        for (i=NLH;i<(NLH+NLE);i++)
        
        {
        
            if (GANN[i].OutData()*GMinData[i-NLH]==GMinData[i-NLH]\
            OR GMaxData[i-NLH]!=0.0\
            AND GANN[i].OutData()*GMaxData[i-NLH]<=GMaxData[i-NLH])
            
            {
            
                if (RunTH<LearnTH)
                
                {
                
                    printf("\n* Output GPin %i *\n",i-NLH+1);
                    printf("Value Found - Little Acurracy!\n\n");
                
                }
                
                else
                
                {
                
                    printf("\n* Output GPin %i *\n",i-NLH+1);
                    printf("Value Found!\n\n");
                
                }
                
                j=1;
                
                break;
            
            }
        
        }
        
        //Final Checks
        if (j==0 AND n==Sims)
        
        {
        
            printf("\nNothing Found!\n\n");
        
        }
        
        else if (j==0 AND n!=Sims)
        
        {
        
            printf("\nNothing Found...System Will Rerun!\n\n");
            
            goto ReRun;
        
        }
        
        //Unload G.A.N.N From Memory
        delete []GANN;
    
    }

}

/* ------------------------------------------------------------------------ */
