/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Error Correction
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Error Correction (Function)
void GErrC(GNeuron *GMatrix,int GNIndex,float Err,int CheckType)

{

    //Variables
    int GNFT;			//GNeuron Function Type
    float e;			//Random Values Variable
    float GNFB;			//GNeuron Function Base
    float GNS;			//GNeuron Summary
    
    //Print Message
    printf("* Error Correction At Neuron %i *\n\n",GNIndex+1);
    
    //Get GNeuron Function Type
    GNFT=GMatrix[GNIndex].GetNFT();
    
    //Get GNeuron Base
    GNFB=GMatrix[GNIndex].GetBase();
    
    //Get GNeuron Sum
    GNS=GMatrix[GNIndex].GetSum();
    
    //Compare GNeuron Summary With GNeuron Base
    if (GNS>=GNFB)
    
    {
    
        //Statistically Weighted Neurons
        if (CheckType==0)
        
        {
        
            //Random e
            if (Err<=25.0)
                e=rand()%(int)Err;
            else
                e=rand()%(int)(50.0-Err+1);
            
            //Make Summary Smaller Than NFunc Base (Output:0)
            GMatrix[GNIndex].Mod=e;
        
        }
        
        //Statically Weighted Neurons
        else if (CheckType==1)
        
        {
        
            //Make Summary Smaller Than GNFB (Output:0)
            GMatrix[GNIndex].Mod=1.0;
        
        }
        
        else
        
        {
        
            printf("Error: Wrong Check Type Specified!\n");
            
            exit(1);
        
        }
    
    }
    
    else
    
    {
    
        //Statistically Weighted Neurons
        if (CheckType==0)
        
        {
        
            //Random e
            if (Err>=25.0)
                e=rand()%(int)Err;
            else
                e=rand()%(int)(100.0-Err);
            
            //Make Summary Bigger Than NFunc Base (Output:1)
            GMatrix[GNIndex].Mod=e;
        
        }
        
        //Statically Weighted Neurons
        else if (CheckType==1)
        
        {
        
            //Make Summary Bigger Than NFunc Base (Output:1)
            GMatrix[GNIndex].Mod=128.0;
        
        }
        
        else
        
        {
        
            printf("Error: Wrong Check Type Specified!\n");
            
            exit(1);
        
        }
    
    }

}

/* ------------------------------------------------------------------------ */
