/* 

   Geeks Artificial Neural Network (G.A.N.N) - Prototypes Library
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Sleep (Function)
void GSleep(int Sec);

//Geeks Data Randomizer (Function)
void GRand();

//Geeks Socket (Class - Model)
class GSocket

{

    private:
    
    //Private Variables
    int SockType;		//Socket Type
    int SockPins;		//Socket Pins
    
    //Structure Of A Geeks Pin
    struct GPin
    
    {
    
        int Type;
        
        int State;
        
        float MinVal;
        
        float MaxVal;
    
    };
    
    //Load Pins Matrix
    GPin *Pins;			//New Pins
    
    
    
    public:
    
    //Constructor
    GSocket();
    
    //Destructor
    ~GSocket();
    
    //Set Socket Type (I/O)
    void SetST(int SType);
    
    //Set Pins Number
    void SetPins(int Num);
    
    //Set Pin Type
    void SetPT(int Pin,int PinType);
    
    //Set Pin State
    void SetPS(int Pin,int PinState);
    
    //Set Pin Single Value Or Value With Range
    void SetPV(int Pin,float Val1,float Val2);
    
    //Get Socket Type (I/O)
    int GetST();
    
    //Get Pins Number
    int GetPins();
    
    //Get Pin Type
    int GetPT(int Pin);
    
    //Get Pin State
    int GetPS(int Pin);
    
    //Get Pin Value Or Pin Value With Range
    float GetPV(int Pin,int Choice);

};

//Geeks Neuron (Class - Model)
class GNeuron

{

    private:
    
    //Private Variables
    int NFT;			//Neuron Function Type
    int Counter;		//A Counter
    int ISPins;			//InSlot Pins
    float Out;			//GNeuron Output
    float *InSlot;		//Inputs Slot (Data Inputs)
    float *Weights;		//Random Inputs Weights
    float Summary;		//A Summary
    float Base;			//Functions Base
    float SigFunc;		//Sigmoid Function Results
    
    //Randmomize Weights
    void RandWeights();
    
    //Sum Up
    void Sum();
    
    //Neuron Function
    void NFunc(int FType);
    
    
    
    public:
    
    //Constructor
    GNeuron();
    
    //Destructor
    ~GNeuron();    
    
    //Public Variables
    float Mod;			//Modulo
    
    //Enable Neuron
    void Enable(int NFType);
    
    //Run Neuron
    void Run(int NFType);
    
    //Input Data
    void InData(int InputPin,float Data);
    
    //Output Data
    float OutData();
    
    //Set Neuron Function Type
    void SetNFT(int NewNFT);
    
    //Set Weights
    void SetWeights(int WPin,float Weight);
    
    //Get Neuron Function Type
    int GetNFT();
    
    //Get Sum
    float GetSum();
    
    //Get Base
    float GetBase();
    
    //Get Input Slot Pins
    int GetISPins();
    
    //Get Weights
    float GetWeights(int WIndex);

};

//Geeks Error Statistics (Function)
float GErrStat(float *FirstData,float *LastData,float *AltData,int StatType);

//Geeks Error Correction (Function)
void GErrC(GNeuron *GMatrix,int GNIndex,float Err,int CheckType);

//Geeks [I/O] Distribution And Map Loader (Function)
void GDMLoader();

//Geeks Generate Data - Value (Function)
float GGenData(int FuncType,float Val);

//Geeks Generate Data - Value In Range (Function) [Over-Loaded]
float GGenData(float Val1,float Val2);

//Geeks Read Data (Function)
void GReadData(GNeuron *GMatrix,int GRegSerNum,long GOffset,int GSimNum);

//Geeks Save Data (Function)
void GSaveData(GNeuron *GMatrix,int GRegSerNum,int GSimNum);

//Geeks Remove Data (Function)
void GRemData(int GRegSerNum,long GOffset);

//Geeks Socket And Neural Map Creator (Function)
void GSNMC();

//Geeks Neural Map Simulator (Function)
void GNMS(int SimFunc);

//Geeks Runtime Manager Console (Function)
void GRMC(int RMCFunc);

//Geeks Exit (Function)
void GExit(int ExitCode,char *ExitMsg);

GSocket InSocket;		//Inputs GSocket
GSocket OutSocket;		//Outputs GSocket

/* ------------------------------------------------------------------------ */
