<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* initialisation des variables globales
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Positionne une variable en globale
	* @param	string	$varname Nom de la variable
	* @param	string	$value	 Valeur de la variable
	* @access	public
	*/
	function SetVarGlobal($varname, $value=''){
	 global $$varname;
		if( !isset($$varname) ) {
			$varname = $value ;
		}
	}

	SetVarGlobal("gfilecss",'');
	SetVarGlobal("gskin",0)    ;
	SetVarGlobal("guser",'')   ;
	SetVarGlobal("gusertype",0);
	SetVarGlobal("guserid",0)  ;

	/**
	* Retourne une date au format FR
	* @param	integer	$datestamp Valeur a transformer en date
	* @return	string	Retourne une date
	* @access	public
	*/
	function date_format_fr($datestamp) {
		$tzoffset = 0;
		if ($datestamp == "") {
			return "";
		}
		if ($datestamp == "0000-00-00") {
			$datestamp = "0000-00-00 00:00:00";
		}
		list($date,$time) = explode(" ",$datestamp)		;
		list($year,$month,$day) = explode("-",$date)	;
		list($hour,$minute,$second) = explode(":",$time);
		$hour = $hour + $tzoffset						;
		$tstamp = mktime($hour,$minute,$second,$month,$day,$year)	;
		$sDate  = date(FORMATDATE,$tstamp)							;
		return($sDate);
	}

	/**
	* Retourne la valeur de la date courante au format datestamp
	* @return	integer	valeur datestamp de la date courante
	* @access	public
	*/
	function FormatDate() {
		$date = getdate() ;
		return($date["0"]);
	}

	/**
	* Met a jour toutes les variables globales correspondant au membre connecte
	* @param	integer	$connexion	valeur de la connexion courante
	* @access	public
	*/
	function SetVar($connexion) {
	 global $guserid,$guser, $gusertype, $gconnexionid, $groupe ;
	 global $TBL, $ClsCnx, $db ;
		$sSQL = "SELECT ".$TBL['connexion'].".id_user, ".$TBL['membres'].".prenom, ".$TBL['membres'].".nom,";
		$sSQL.= $TBL['membres'].".type, ".$TBL['membres'].".id_groupe ";
		$sSQL.= "FROM ".$TBL['connexion'].",".$TBL['membres']." ";
		$sSQL.= "WHERE ".$TBL['connexion'].".id_connexion='".$connexion."' AND ".$TBL['connexion'].".id_user=".$TBL['membres'].".id";
		$db->query($sSQL);
		$db->next_record($sSQL);
		if ( $db->num_rows() !=  0) {
			$guserid		= $db->f(0)	;
			$guser			= $db->f(1)." ".$db->f(2);
			$gusertype		= $db->f(3)	;
			if ( $gusertype == STAGIAIRE ) { // STAGIAIRE
				$groupe			= $db->f(4)	;
			}
			$gconnexionid	= $connexion;
			$db->free()					;
			$ClsCnx->Refresh($connexion);
			return(1);
		} else {
			return(0);
		}
	}

	/**
	* Verification de la connexion ou du couple login/password
	* @param	string	$txtuser	valeur du login
	* @param	string	$txtpassword	valeur du password
	* @return	integer	1 si la connexion est ok, 0 sinon
	* @access	public
	*/
	function Login($txtuser='',$txtpassword='') {
		global $guserid,$newskin, $ClsCnx, $ClsColor ;
		$res = $ClsCnx->Login($txtuser, $txtpassword);
		if ($res > 0 ) {
			$ClsCnx->NewCnx($guserid);
			if ( isset($newskin) && $newskin!='' ) {
				$ClsColor->Set($guserid,$newskin) ;
			} else {
				$ClsColor->Read($guserid);
			}
		}
		return $res ;			
	}
		
	/**
	* Verification de la connexion ou du couple login/password
	* @param	integer	$connexion	valeur de la connexion courante
	* @param	string	$txtuser	valeur du login
	* @param	string	$txtpassword	valeur du password
	* @return	integer	1 si la connexion est ok, 0 sinon
	* @access	public
	*/
	function Init($connexion) {
	 global $guserid, $gusertype,$newskin, $ClsCnx, $ClsColor, $db ;
		$res = 1 ;
		$guserid   = 0 ;
		$gusertype = -1;

		$ClsCnx->DeleteOldCnx();

		if ($connexion == '') {
			PageErreur();
	    	exit()      ;
		} else {
			$res = SetVar($connexion) ;
		}
		if ( $res > 0 ) {
			if ( isset($newskin) && $newskin!='' ) {
				$ClsColor->Set($guserid,$newskin) ;
			} else {
				$ClsColor->Read($guserid);
			}
		} else {
			PageErreur();
	    	exit()      ;			
		}
		return $res ;
	}


	$version = '0.0';  
    if( file_exists(RP_MAIN."version.txt") ) {
		$file = RP_MAIN."version.txt" ;
		$fd=fopen($file,"rb	");
		$size = filesize($file) ;
		$version = fread($fd,filesize($file));
		fclose($fd);
	} 
	define('VERSION','ver. '.$version);
?>