<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des groupes
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche les information d'un groupe
	* @access	public
	*/
	function InfoGroupe() {
	 global $guserid, $ClsMembre, $ClsGroupe, $gconnexionid, $ext ; 
	 global $st_titre, $st_texte ;
		BR();
		$img = '<img src="'.HTTP_IMAGES.'groupe.gif" border="0" alt="'.$st_titre['gtp'].'" />&nbsp;&nbsp;';
		SubTitleImage($st_titre['gtp'],$img); 
		BR();
		$ret = $ClsMembre->GetGroupe($guserid);
		$grp	  = $ret['groupe']	;
		$idgroupe = $ret['idgroupe'];
		if ( $grp == "" || $idgroupe == 0 ) {
			$href_groupe = "<b>".CSS($grp)."</b>" ;
		} else {
			$url   = HTTP_COMMUN."p_groupe".$ext."?groupe=".$idgroupe."&connexion=".$gconnexionid ;
			$click = "onClick=\"openWindow('".$url."','fenetre','scrollbars=yes,width=620,height=400')\" ";
			$out   = "onMouseOut=\"window.status='Ganesha ".VERSION."';return true;\""		;
			$over  = "onMouseOver=\"window.status='Visualisez votre groupe';return true;\""	;
			$href_groupe = "<a class=student href=\"#\" ".$click." ".$over." ".$out.">".CSS($grp)."</a>" ;
		}
		$planning = $ClsGroupe->Planning($idgroupe) ;
		if ( $planning == "" ) {
			$href_planning = "#" ;
			$txt_planning  = $st_texte['noplanning'];
		} else {
			$dir = RP_GROUPES.$ClsGroupe->Directory($idgroupe).'/' ;
			$href_planning = 'href="'.HTTP_COMMUN.'download.php?connexion='.$gconnexionid ;
			$href_planning.= '&dir='.urlencode($dir).'&filename='.urlencode($planning).'&planning=1"' ;
			$href_planning.= ' target="_blank" ' ;
			$txt_planning  = $st_texte['planning'] ;
		}
		$tuteur = $ClsMembre->GetTuteur($idgroupe)  ;
		$out    = 'onMouseOut="window.status=\'Ganesha '.VERSION.'\';return true;"';
		$over   = 'onMouseOver="window.status=\'Planning\';return true;" '			;
		$a		= '<a class="student" '.$href_planning.' '.$over.'  '.$out.'>'.$txt_planning.'</a>'	;
		put('			<table width="100%" border="0" cellspacing="0" cellpadding="0" >')	;
		if ( OPT_STUDENT_SHOW_GROUPE_ACTIVE ) {
			put('			  <tr><td>'.$st_texte["visugrp"].$href_groupe.'</td></tr>')			;
		}
		put('			  <tr><td>'.$st_texte["tuteur"].'<B>'.$tuteur.'</B></td></tr>')		;
		put('			  <tr><td>&nbsp;</td></tr>')						;
		put('			  <tr><td>'.$st_texte["plangrp"].$a.'</td></tr>')	;
		put('			  <tr><td>&nbsp;</td></tr>');
		put('			</table>')	;
	}

	/**
	* Affiche les membres d'un groupe
	* @param	integer	$idg	Id du groupe 
	* @param	string	$target	Id du groupe 
	* @access	public
	*/
	function DisplayGroupe($idg,$target='') {
	 global $color2, $gconnexionid, $ext, $gusertype ;
	 global $st_titre, $st_texte, $st_table ;
	 global  $ClsTracking, $ClsGroupe, $ClsMembre ;
		SubTitle($st_titre['compogrp'])	;
		BR();
		BeginBorder("90%",$color2)		;

		put('<table align="middle" width="100%" border="0" cellspacing="0" cellpadding="5">');
		put('  <tr align="left" bgColor="'.$color2.'" >');
		put('    <td width="30%" class="title2">'.$st_table['prenom'].'</td>');
		put('    <td width="17%" class="title2">'.$st_table['nom'].'</td>');
		put('    <td width="15%" class="title2">'.$st_table['score'].'</td>');
		put('    <td width="23%" class="title2">'.$st_table['dernierecnx'].'</td>');
		put('    <td width="15%" class="title2">'.$st_table['nbcnx'].'</td>');
		put('  </tr>');

		$tGroupe = $ClsGroupe->Members($idg);
		for ( $i=0; $i<$tGroupe['cnt']; $i++) {
			$id = $tGroupe[$i]['id']				;
			put('  <tr bgcolor="'.GetColor($i).'">');
			$status	= Status('groupe');

			put('    <td>'.CSS(Unreplace($tGroupe[$i]['prenom'])).'</td>')	;				
			put('    <td>'.CSS(Unreplace($tGroupe[$i]['nom'])).'</td>')		;
			
			$url	= HTTP_COMMUN.'p_resultat'.$ext.'?connexion='.$gconnexionid.'&stagiaire=1&userid='.$id.'&groupe='.$idg	;
			$status	= Status('groupe');
			$nb		= $ClsTracking->Nb($id,$idg);
			$text	= $st_texte['details'].'('.$nb.')' ;
			if ( $gusertype == STAGIAIRE  ) {
				if ( OPT_STUDENT_SHOW_RESULT_ACTIVE ) {
					//put('    <td><a class="student" href="'.$url.'" '.$status.'>'.$text.'</a></td>');
					$click = "onClick=\"openWindow('".$url."','".$target."','scrollbars=yes,width=620,height=400')\" ";
					put('    <td><a class="student" href="#" '.$click.$status.'>'.$text.'</a></td>') ;					
				} else {
					put('    <td>'.$text.'</td>') ;
				}
			} else {
				if ( $target == '' ) {
					put('    <td><a class="student" href="'.$url.'" '.$status.'>'.$text.'</a></td>');
				} else {
					$click = "onClick=\"openWindow('".$url."','".$target."','scrollbars=yes,width=620,height=400')\" ";
					put('    <td><a class=student href="#" '.$click.$status.'>'.$text.'</a></td>') ;
				}
			}
			put ('    <td>'.$ClsMembre->GetDateConnexion($id).'</td>')	;
			if ( $gusertype == STAGIAIRE && !OPT_STUDENT_SHOW_DETAIL_ACTIVE ) {
				put ('    <td>'.$ClsMembre->GetNbConnexion($id).'</td>')	;
			} else {
				$url	= HTTP_COMMUN.'p_details'.$ext.'?connexion='.$gconnexionid.'&id_membres='.$id.'&groupe='.$idg	;
				$click = "onClick=\"openWindow('".$url."','".$target."d','scrollbars=yes,width=620,height=400')\" ";
				put('    <td><a class=student href="#" '.$click.$status.'>'.$ClsMembre->GetNbConnexion($id).'</a></td>')	;
			}				
			put ('  </tr>') ;
		} 
		put('</table>')	;
		Closeborder()	;
		BR()			;
	}

?>