<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* fonctions utilises pour les valuations annexes
*
* @author		Eric Villard <evillard@nef.fr>
* @package		GaneshaInc
*/

/**
* recherche dichotomique de prsence
* @param	array	$tab	tableau cible
* @param	variant	$val	valeur  cherher
* @return	boolean
* @access	public
*/

function rechDicho ($tab, $val) {
	$lgtab=count($tab);
	$trouve=false;
	if ($val>=$tab[0] && $val<=$tab[$lgtab-1]) {
		$inf=0;
		$sup=$lgtab;
		while (($inf < $sup) && !$trouve) {
			$demi = floor(($inf+$sup)/2);
			if ($tab[$demi]==$val) {
				$trouve=true;
			} elseif ($tab[$demi]>$val) {
				$sup=$demi-1;
			} else {
				$sup=$demi+1;
			}
		}
	}
	return $trouve;
}

/**
* procdure rcursive dcomposant un tableau dont les lments sont de 2 types string et array
* afin de composer un tableau dont les lments sont des tableaux de mme type
* @param	array	$tab	tableau cible
* @param	array	&$t		tableau rsultat
* @access	public
*/

function dtab ($tab,&$t) {
	reset($tab);
	while (list($cle, $val) = each($tab)) {
		if (gettype($val)=="array") {
			dtab ($val,$t);	
		} else {
			$t[count($t)] = array($cle=>$val);
		}
	}
}


?>