<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des formulaires, tableau de la partie admin
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Permet de verifier l'autorisation des pages admin pour un tuteur
	* @access	public
	*/					  
	function secure_admin() {
		global $gusertype, $PAGE_ADMIN_TUTEUR;
		if ( $gusertype!=ADMIN && $gusertype!=TUTEUR ) {
			 PageErreur();
			 exit();
		}
		if ( $gusertype == TUTEUR ) {
			if ( $PAGE_ADMIN_TUTEUR[SUBMENU] == false ) {
				PageErreur();
			 	exit();
			}
		}
	}
					  
	/**
	* Affiche le menu du profil Admin
	* @access	public
	*/
	function HeaderAdmin() {
	 global $PAGE_ADMIN, $ad_pmenu ;
	    GaneshaHeader();
		BeginHeader();
		AddMenu3(0,"20%","","");
		AddMenu3(0,"20%",$ad_pmenu[0],HTTP_MAIN.'index.php' )	;
		AddMenu3(1,"20%",$ad_pmenu[1],HTTP_ADMIN.$PAGE_ADMIN[0])	;		
		AddMenu3(2,"20%",$ad_pmenu[2],'options.php');
		//AddMenu(3,"15%",'UPDATE','update.php')	;
		//AddMenu(4,"5%",'','')	;
		AddMenu3(3,"20%",'','')	;
		CloseHeader();
	}

	/**
	* Retourne la couleur des formulaires de la partie admin
	* @access	public
	*/
	function CouleurForm() { 
		global $color1a, $color4 ;
		return $color1a;
	}

	/**
	* Affiche le titre de la page dans un tableau + ancre nomme 'haut'
	* @param	string	$titre	titre de la page
	* @access	public
	*/
	function GetTitre($titre) { 
		global $color1, $gconnexionid, $header ;
		$titre =  $titre ; //." : ".$ad_titre[SUBMENU];
		//$lexport = HTTP_COMMUN."p_export.php?connexion=".$gconnexionid.'&menu='.SUBMENU ;
		//$xls = '<a href="'.$lexport.'&format='.EXPORT_XLS.'" ><img border="0" hspace="2" src="'.HTTP_IMAGES.'xls.gif"  alt="excel"></a>';
		//$xml = '<a target="_blank" href="'.$lexport.'&format='.EXPORT_XML.'" ><img border="0" hspace="2" src="'.HTTP_IMAGES.'xls.gif"  alt="excel"></a>';		
		$xml = '';		
		$xls = '';		
		put('
<a name="haut"></a>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
<tr bgcolor="'.$color1.'" >
  <td height="25">
	<b><a href="#"><img border=0 hspace="2" src="'.HTTP_IMAGES.'reload.gif"  alt="'.$header['refresh'].'" onclick="window.location.reload()"></a>&nbsp;'.$titre.'</b>
  </td>
  <td align="right" height="25">
	'.$xml.'&nbsp;'.$xls.'&nbsp;<a href="#"><img border=0 hspace="2" src="'.HTTP_IMAGES.'printer.gif"  alt="'.$header['print'].'" OnClick="javascript:window.print()"></a>
  </td>
</tr>
</table><br>');
     }

	/**
	* Affiche un element du menu admin
	* @param	integer	$num	numero du menu
	* @access	public
	*/
	function itemMenu($num) {
		global $ad_titre,$connexion, $ext, $color2, $color1a, $color1, $headercolor, $PAGE_ADMIN, $gusertype;
		if ( !isset($ad_titre[$num]) || $ad_titre[$num] == '' ) return ;
		if ( $num == SUBMENU ) {
			 $action= '' ;
			 $color = $color1a ;
			 $class = "HEADER2";
		} else {
			 $color = $color2  ;
			 $class = "HEADER1";
			 $action = 'onmouseover="setPointer(this, \'over\', \''.$color2.'\',\''.$headercolor.'\')" onmouseout="setPointer(this, \'out\', \''.$color2.'\',\''.$headercolor.'\')" onmousedown="setPointer(this, \'click\', \''.$color2.'\',\''.$headercolor.'\')"';
		}
		$url = HTTP_ADMIN.$PAGE_ADMIN[$num].'?connexion='.$connexion.'&action=liste';
		$target = ($gusertype==ADMIN?'':'target="FrmMain"');
		put( '    <tr valign="center" height="30" bgcolor="'.$color.'" '.$action.' >');
		put( '    <td>&nbsp;<A href="'.$url.'" '.$target.' class="'.$class.'">'.IMG_RIGHT.'&nbsp;'.$ad_titre[$num].'</a></td>');
		put( "    </tr>");
	}

	/**
	* Affiche le menu admin
	* @access	public
	*/	
	function menuUtil() {
		global $ad_utils,$gconnexionid, $ext, $color2, $color1a;
	 	$color = $color2  ;
		$class = "HEADER1";
		BR();
		BeginBorder("95%",$color1a,$ad_utils[0]);
		put('<table valign="top" width="100%" border="0" cellspacing="0" cellpadding="0">');

		$url = HTTP_BDD.'index'.$ext.'?connexion='.$gconnexionid ;
		$click = " onClick=\"openWindow('".$url."','bdd','scrollbars=yes,width=780,height=590')\" ";
		put( '    <tr bgcolor="'.$color.'">');
		put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[1].'</li></a></td>');
		put( "    </tr>");		

		/*
		$url = HTTP_INSCRIPTION.'index.php?connexion='.$gconnexionid ; 
		$click = " onClick=\"openWindow('".$url."','inscription','scrollbars=yes,width=750,height=590')\" ";
		put( '    <tr bgcolor="'.$color.'">');
		put( '    <td><a href="#" '.$click.' class="'.$class.'" ><li>'.$ad_utils[9].'</li></a></td>');
		put( "    </tr>");
		*/
		if ( TRACE ) {
			$url = HTTP_COMMUN.'p_trace.php?connexion='.$gconnexionid.'&file_trace='.urlencode(RP_TRACE_FILE);	
			$click = " onClick=\"openWindow('".$url."','sql_log','scrollbars=yes,width=700,height=590')\" ";
			put( '    <tr bgcolor="'.$color.'">');
			put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[2].'</li></a></td>');
			put( "    </tr>");
		}

		if ( DEBUG ) {		
			$url = HTTP_COMMUN.'p_trace.php?connexion='.$gconnexionid.'&file_trace='.urlencode(RP_DEBUG_FILE);	
			$click = " onClick=\"openWindow('".$url."','sql_log','scrollbars=yes,width=700,height=590')\" ";
			put( '    <tr bgcolor="'.$color.'">');
			put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[3].'</li></a></td>');
			put( "    </tr>");
		}
		
		if ( DEBUG_AICC ) {
			$url = HTTP_COMMUN.'p_trace.php?connexion='.$gconnexionid.'&file_trace='.urlencode(RP_AICC_MSG_FILE);	
			$click = " onClick=\"openWindow('".$url."','sql_log','scrollbars=yes,width=700,height=590')\" ";
			put( '    <tr bgcolor="'.$color.'">');
			put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[4].'</li></a></td>');
			put( "    </tr>");
	
			$url = HTTP_COMMUN.'p_trace.php?connexion='.$gconnexionid.'&file_trace='.urlencode(RP_AICC_RES_FILE);	
			$click = " onClick=\"openWindow('".$url."','sql_log','scrollbars=yes,width=700,height=590')\" ";
			put( '    <tr bgcolor="'.$color.'">');
			put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[5].'</li></a></td>');
			put( "    </tr>");
		}
		
		$url = HTTP_COMMUN."p_filemanager.php?connexion=".$gconnexionid.'&cmd='.CMD_ALL; ;
		$click = " onClick=\"openWindow('".$url."','manager','scrollbars=yes,width=700,height=590')\" ";
		put( '    <tr bgcolor="'.$color.'">');
		put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[6].'</li></a></td>');
		put( "    </tr>");

		$url = HTTP_FORUM.'admin/index'.$ext.'?connexion='.$gconnexionid ;
		$click = " onClick=\"openWindow('".$url."','forum','scrollbars=yes,width=700,height=590')\" ";
		put( '    <tr bgcolor="'.$color.'">');
		put( '    <td><a href="#" class="'.$class.'" '.$click.'><li>'.$ad_utils[7].'</li></a></td>');
		put( "    </tr>");

		$url = HTTP_PHPMYADMIN ;
		put( '    <tr bgcolor="'.$color.'">');
		put( '    <td><a href="'.$url.'" target="_blank" class="'.$class.'" ><li>'.$ad_utils[8].'</li></a></td>');
		put( "    </tr>");

		put('</table>');
		CloseBorder();				
	}

	/**
	* Affiche le menu admin
	* @access	public
	*/
	function menuAdmin() { 
		global $ad_titre, $gusertype, $color1a,$PAGE_ADMIN_TUTEUR ;
		BR(2);
				
		if ( $gusertype != TUTEUR ) {
			ViewSkin();
		}

		BeginBorder("95%",$color1a);
		put('<table valign="top" width="100%" border="0" cellspacing="0" cellpadding="0">');
		//put('<tr bgcolor="'.$color2.'"><td>&nbsp;&nbsp;</td></tr>');

		$cnt = count($ad_titre) ;
		for ($i=0;$i<$cnt;$i++) {
			if ( $gusertype == ADMIN ) {
				itemMenu ($i);
			} else {
				if ( $PAGE_ADMIN_TUTEUR[$i]==true ) {
					itemMenu ($i);
				}
			}
		}
		//put('<tr bgcolor="'.$color2.'"><td>&nbsp;&nbsp;</td></tr>');				
		put('</table>');
		CloseBorder();
		if ( $gusertype != TUTEUR ) {		
			menuUtil() ;
		}
		put('<center>');put_copyright_GANESHA();put('</center>');						
	}

	/**
	* Affiche la page admin en fonction de l'action
	* @access	public
	*/
	function selectAction() {
		global $ClsPageAdmin ;
		switch(ACTION) {
		case 'liste_user':	$ClsPageAdmin->liste_user();break;					
		case 'liste_tutor':	$ClsPageAdmin->liste_tutor();break;		
		case 'liste':		$ClsPageAdmin->liste()	;	break;
		case 'add'	:		$ClsPageAdmin->add()	;	break;
		case 'modif':		$ClsPageAdmin->modif()	;	break;
		case 'delete':		$ClsPageAdmin->del()	;	break;
		default:			$ClsPageAdmin->liste()	;	break;				
		}
		Footer();		
	}

	/**
	* Affiche la page admin en fonction de OPT_MENU_ADMIN_LEFT_ACTIVE
	* @access	public
	*/
	function pageAdmin() {
		global $ad_menu, $color2, $color1a, $BodyColor,$gusertype, $ClsPageAdmin ;
		
		secure_admin();
		
		$ClsPageAdmin->traite_post()	;
		$ClsPageAdmin->traite_get()		;
		InitPageHtml('Admin ganesha')	;

		if ( $gusertype == ADMIN ) {
			HeaderAdmin();
		}

		put('<table width="100%" border="0" cellspacing="0" cellpadding="0"  bgcolor="'.$BodyColor.'" >');
		put('<tr valign="top">');
		if ( OPT_MENU_ADMIN_LEFT_ACTIVE && $gusertype==ADMIN ) {
			put('<td width="85%">');
			selectAction();
			put('</td><td width="15%" valign="left" bgcolor="'.$color2.'">');
			menuAdmin();
			put('</td>');			
		} else {
			put('<td width="15%" valign="left" bgcolor="'.$color2.'">');
			menuAdmin();
			put('</td><td width="85%">');
			selectAction();
			put('</td>');
		}
		put('</tr></table>');
//		put('<a target="_blank" href="http://www.anema.fr"><img src="'.HTTP_IMAGES.'conception.gif" width="800" height="59" border="0" alt="GANESHA"></a>');
		ClosePageHtml();
	}


?>