<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page des graphs
*
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaCommun
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");

	$module		= $HTTP_GET_VARS['module']		;
	$chapitre	= $HTTP_GET_VARS['chapitre']	;

	include_once(RP_JPGRAPH."jpgraph.php")		;
	include_once(RP_JPGRAPH."jpgraph_line.php")	;
	include_once(RP_JPGRAPH."jpgraph_bar.php")	;
	include_once(RP_JPGRAPH."jpgraph_pie.php")	;
	include_once(RP_JPGRAPH."jpgraph_error.php")	;

if ( $chapitre != '' ) {
	$ClsTracking->InitListChapterA($guserid,$module,$chapitre);
	$i = 1 ;
	while ( $ret = $ClsTracking->NextItem() ) {
		$chapitre	= $ret['chapitreId'];
		$date		= $ret['date']		;
		$note		= $ret['note']		;
		$temps		= $ret['temps']		;
		$ydata[]	= $note				;
		$ydata2[]	= $temps			;
		$xdata[]	= $i++	;	
		$pdata[$chapitre]++ ;
	}

	if ( $i == 1 ) die("<b>Pas de valeurs.....</b>");

	$titre = $ClsChapitre->Title($module,$chapitre) ;

	$lg = ( $i<20 ? 450 : ($i*30)) ;

	// Create the graph. These calls are always required
	$graph = new Graph($lg,200,"auto");	
	$graph->SetScale("textlin");
	$graph->img->SetMargin(40,20,30,70);   
	$graph->SetMarginColor('white'); 
	$graph->SetColor('white'); 
	$graph->title->Set($titre." (".($i-1).")"); 
	$graph->title->SetFont(FF_FONT1,FS_BOLD); 

	$graph->yaxis->title->Set(""); 
	$graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD); 
	$graph->yaxis->SetColor($color2);
	$graph->yaxis->SetWeight(2);

	$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD); 
	$graph->xaxis->SetColor($color2);
	$graph->xaxis->SetTickLabels($xdata); 
	$graph->xaxis->SetTextTickInterval(1); 

	// Create the linear error plot 
	$l1plot=new LinePlot($ydata2); 
	$l1plot->value->Show();
	$l1plot->SetColor($color2); 
	$l1plot->SetWeight(2); 
	$l1plot->SetLegend($st_texte['result1']); //score

	// Create the bar plot 
	$l2plot = new BarPlot($ydata); 
	$l2plot->SetFillColor($color2); 
	$l2plot->SetLegend($st_texte['temps']); //temps
	$l2plot->SetFillGradient($color2,"white",GRAD_MIDVER);

	// Add the plots to the graph 
	$graph->Add($l2plot); 
	$graph->Add($l1plot); 

	$graph->legend->SetLayout(LEGEND_HOR); 
	$graph->legend->Pos(0.5,0.85,"center","center"); 


	// Create the graph. 
	$graph->SetShadow(); 

	// Display the graph
	$graph->Stroke();

} else {
// le fromage....
	$ClsTracking->InitListModule($guserid,$module);
	$i = 1 ;
	while ( $ret = $ClsTracking->NextItem() ) {
		$chapitre	= $ret['chapitreId'];
		$vdata[$chapitre]++ ;
		$tdata[$chapitre] = $ClsChapitre->Title($module,$chapitre) ;
		$i++ ;
	}
	if ( $i == 1 ) die("<b>Pas de valeurs.....</b>");

	$data = array_values($vdata);
	$tdata = array_values($tdata);
	for($i=0;$i<count($tdata);$i++) {
		$tdata[$i] = $tdata[$i]." (".$data[$i].")";
	}

	$titre = $ClsModule->Title($module);

	// Create the Pie Graph. 
	$graph = new PieGraph(460,420,"auto"); 
	$graph->img->SetMargin(40,20,30,70);   
	$graph->SetMarginColor('white'); 
	$graph->SetColor('white'); 
	$graph->title->Set($titre); 
	$graph->title->SetFont(FF_FONT1,FS_BOLD); 
//	$graph->legend->SetLayout(LEGEND_HOR); 
	$graph->legend->Pos(.2,.9,"center","center"); 

	$graph->SetShadow(); 

	// Create 
	$p1 = new PiePlot($data); 
	$p1->SetLegends($tdata); 
	$graph->Add($p1); 
	$graph->Stroke(); 
}

?>