<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des messages
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux WebMails
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class WebMail {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise la connexion locale
	* @access	public
	*/
	function WebMail() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* Initialise la liste des messages en emission/reception
	* @param	integer	$idu ID du membre
	* @param	integer	$cmd_wm commande (Reception/Emission)
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function InitList($idu,$cmd_wm,$idg) {
	 global $TBL;
		if ( $cmd_wm == CMD_WM_INBOX ) {
			// Reception
			$sSQL = "SELECT m.id,u.prenom,u.nom,m.objet,m.text,m.date,m.lu,m.dest,m.fichier,m.AR,m.type ";
			$sSQL.= "FROM ".$TBL['mes_rec']." m, ".$TBL['membres']." u " ;
			$sSQL.= "where (m.dest=".$idu." and m.source=u.id and m.groupe=".$idg.") ";
			$sSQL.= "order by m.id DESC" ;
		}else {
			$sSQL = "SELECT m.id,u.prenom,u.nom,m.objet,m.text,m.date,m.lu,m.dest,m.fichier,m.AR,m.type ";
			$sSQL.= "FROM ".$TBL['mes_send']." m, ".$TBL['membres']." u  " ;
			$sSQL.= "where (m.source=".$idu." and m.dest=u.id and m.groupe=".$idg.") ";
			// Tout le groupe
			$sSQL.= "OR (m.dest=-1 and m.source=".$idu." and m.source=u.id and m.groupe=".$idg.") "; 
			// Tous les tuteurs
			$sSQL.= "OR (m.dest=-2 and m.source=".$idu." and m.source=u.id and m.groupe=".$idg.") "; 
			$sSQL.= "order by m.id DESC" ;
		}
		$this->_db->query($sSQL);
	}

	/**
	* Retourne le message suivant 
	* @return	array Retourne un tableau avec tous les elements d'un message ou sinon false
	* @access	public
	*/
	function NextItem() {
		if ( $this->_db->next_record() ) {
			$msg['id']		= $this->_db->f("id")								;
			$msg['user']	= $this->_db->f("prenom")." ".$this->_db->f("nom")	;
			$msg['message']	= Unreplace($this->_db->f("text"))					;
			$msg['objet']	= Unreplace($this->_db->f("objet"))					;
			$msg['date']	= $this->_db->f("date")								;
			$msg['lu']		= $this->_db->f("lu")								;
			$msg['type']	= $this->_db->f("type")								;
			$msg['file']	= $this->_db->f("fichier")							;
			$msg['AR']		= $this->_db->f("AR")								;
			return($msg);
		}
		return(false);
	}

	/**
	* Prepare le corps du message pour un transfert ou pour faire suivre
	* @param	integer	$id Id du message
	* @return	string Retourne un message pre-formate pour effectuer un transfert ou pour faire suivre
	* @access	public
	*/
	function GetMessageReplyForward($id) {
	 global $TBL, $reply, $db, $st_texte ;
		$ret['message'] = "" ;
		$ret['id_user'] = "" ;
		$sSQL = "SELECT u.prenom,u.nom,m.source,m.text,m.date "		;
		$sSQL.= "FROM ".$TBL['mes_rec']." m, ".$TBL['membres']." u "	;
		$sSQL.= "WHERE m.id=".$id." AND u.id=m.source"				;
		$db->query($sSQL) ;
		if ( $db->next_record()) {
			$ret['message'] = ( (isset($reply) && $reply!="") ? $st_texte['wmreply'] :$st_texte['wmforward'])	;
			$ret['message'].= "\n\n\n\n\n-----------------\n"					;
			$ret['message'].= sprintf($st_texte['wmmessage'],$db->f("date"),$db->f("prenom")." ".$db->f("nom")) ;
			//"Message envoy le ".$db->f("date")." \npar ".$db->f("prenom")." ".$db->f("nom")."\n>>";
			$ret['message'].= Unreplace($db->f("text"))	;
			$ret['id_user'] = $db->f("source")			;
			$db->free();
		}
		return($ret) ;
	}

	/**
	* Envoie un message au tuteur
	* @param	integer	$ids ID du membre source du message
	* @param	string	$obj objet du message	
	* @param	string	$msg corps du message
	* @param	integer	$idg Id du groupe
	* @param	string	$file fichier attache
	* @param	string	$AR accuse de reception
	* @return	boolean Retourne la valeur true
	* @access	public
	*/
	function SendTutor($ids,$obj,$msg,$idg,$file,$AR) {
	 global $TBL, $db ;
		$date = getdate()	;
		$date = date(FORMATDATE,$date["0"]);
		// dest = -2 pour indiquer que le webmail est envoye a tous les tuteurs
		$myAR = ($AR==""?0:1) ;
		$sSQL = "INSERT INTO ".$TBL['mes_send']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
		$sSQL.= "values (".$ids.",'-2','".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",2)" ;
		$db->query($sSQL)  ;
		// Get the tutors groupe 
		$sSQL = "SELECT m.id FROM ".$TBL['membres']." m,".$TBL['list_groupe']." g ";
		$sSQL.= "WHERE g.id_groupe=".$idg." AND m.id=g.id_tuteur ORDER BY prenom ASC,nom";
		$db->query($sSQL)  ;
		$cpt = 1 ;
		while ( $db->next_record() ) {
			if ( $ids != $db->f(0) ) {
				$sSQL = "INSERT INTO ".$TBL['mes_rec']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
				$sSQL.= "values (".$ids.",".$db->f(0).",'".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",2)" ;
				$cpt ++ ;
				$this->_db->query($sSQL) ;
			}
		}
		if ( $file != "" ) {
			$sSQL = "INSERT INTO ".$TBL['mes_doc']." (fichier,compteur) " ;
			$sSQL.= "values ('".$file."',".$cpt.")" ; // source + dest = 2
			$db->query($sSQL)  ;
		}	
		return(true);
	}

	/**
	* Envoie un message a tout le groupe
	* @param	integer	$ids ID du membre source du message
	* @param	string	$obj objet du message	
	* @param	string	$msg corps du message
	* @param	integer	$idg Id du groupe
	* @param	string	$file fichier attache
	* @param	string	$AR accuse de reception
	* @return	boolean Retourne la valeur true
	* @access	public
	*/
	function SendGroupe($ids,$obj,$msg,$idg,$file,$AR) {
	 global $TBL, $db ;
		$date = getdate()				;
		$date = date(FORMATDATE,$date["0"]);
		// dest = -1 pour indiquer que le webmail est envoye a tout le groupe
		$myAR = ($AR==""?0:1) ;
		$sSQL = "INSERT INTO ".$TBL['mes_send']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
		$sSQL.= "values (".$ids.",'-1','".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",1)" ;
		$db->query($sSQL)  ;
		// Get the users groupe 
		$sSQL = "SELECT id FROM ".$TBL['membres']." WHERE type=0 and id_groupe=".$idg." order by prenom ASC,nom";
		$db->query($sSQL)  ;
		$cpt = 1 ;
		while ( $db->next_record() ) {
			if ( $ids != $db->f(0) ) {
				$sSQL = "INSERT INTO ".$TBL['mes_rec']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
				$sSQL.= "values (".$ids.",".$db->f(0).",'".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",1)";
				$cpt ++ ;
				$this->_db->query($sSQL)  ;
			}
		}
		// Get the tutors groupe 
		$sSQL = "SELECT m.id FROM ".$TBL['membres']." m,".$TBL['list_groupe']." g ";
		$sSQL.= "where g.id_groupe=".$idg." and m.id=g.id_tuteur order by prenom ASC,nom";
		$db->query($sSQL)  ;
		while ( $db->next_record() ) {
			if ( $ids != $db->f(0) ) {
				$sSQL = "INSERT INTO ".$TBL['mes_rec']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
				$sSQL.= "values (".$ids.",".$db->f(0).",'".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",1)";
				$cpt ++ ;
				$this->_db->query($sSQL)  ;
			}
		}
		if ( $file != "" ) {
			$sSQL = "INSERT INTO ".$TBL['mes_doc']." (fichier,compteur) "  ;
			$sSQL.= "values ('".$file."',".$cpt.")" ; // source + dest = 2
				$this->_db->query($sSQL)  ;
		}
		return(true);
	}

	/**
	* Envoie un message a un membre
	* @param	integer	$ids ID du membre source du message
	* @param	integer	$idd ID du membre destinataire du message
	* @param	string	$obj objet du message		
	* @param	string	$msg corps du message
	* @param	integer	$idg Id du groupe
	* @param	string	$file fichier attache
	* @param	string	$AR accuse de reception
	* @return	boolean Retourne la valeur true
	* @access	public
	*/
	function SendUser($ids,$idd,$obj,$msg,$idg,$file,$AR) {
	 global $TBL, $db ;
		$date = getdate()				;
		$date = date(FORMATDATE,$date["0"]);
		$myAR = ($AR==""?0:1) ;
		$sSQL = "INSERT INTO ".$TBL['mes_send']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
		$sSQL.= "values (".$ids.",".$idd.",'".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",0)" ;
		$db->query($sSQL)  ;
		$sSQL = "INSERT INTO ".$TBL['mes_rec']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "  ;
		$sSQL.= "values (".$ids.",".$idd.",'".$obj."','".$msg."','".$date."',0,".$idg.",'".$file."',".$myAR.",0)" ;
		$db->query($sSQL)  ;
		if ( $file != "" ) {
			$sSQL = "INSERT INTO ".$TBL['mes_doc']." (fichier,compteur) " ;
			$sSQL.= "values ('".$file."',2)"; // source + dest = 2
			$db->query($sSQL)  ;
		}
		return(true);
	}

	/**
	* Envoie un accuse de reception
	* @param	integer	$idd ID du membre destinataire du message
	* @param	string	$msg corps du message
	* @return	boolean Retourne la valeur true
	* @access	private
	*/
	function SendAR($idd,$msg) {
	 global $TBL, $ClsMembre, $groupe, $guser, $db, $st_texte ;
		$root = $ClsMembre->GetIdRoot();
		$date = getdate()					;
		$date = date(FORMATDATE,$date["0"])	;
		$lmsg = sprintf($st_texte['accuserecept'],Replace($msg));
		$lmsg = $lmsg.' '.$guser	;
		$sSQL = "INSERT INTO ".$TBL['mes_rec']." (source,dest,objet,text,date,lu,groupe,fichier,ar,type) "	;
		$sSQL.= "values (".$root.",".$idd.",'".$st_texte['repacrecept']."','".$lmsg."','".$date."',0,".$groupe.",'',0,0)"			;
		$db->query($sSQL)	;
		return(true)		;
	}

	/**
	* retourne le nombre de messages recu/emis et le nombre de messages non lu
	* @param	integer	$idu ID du membre 
	* @param	integer	$cmd_wm indique si message recu ou message emis.
	* @param	integer	$idg Id du groupe
	* @return	array Retourne un tableau avec le nombre de message recu/emis + nombre de message non lu.
	* @access	public
	*/
	function NbMessage($idu,$cmd_wm,$idg) {
	 global $TBL, $db ;
		$ret['nb']  = 0 ;
		$ret['nb2'] = 0 ;
		if ( $cmd_wm == CMD_WM_INBOX ) {
			// Reception
			$sSQL = "SELECT id FROM ".$TBL['mes_rec']."  where dest=".$idu." and groupe = ".$idg ;
			$db->query($sSQL)	;
			$ret['nb'] = $db->num_rows()	;
			$sSQL = "SELECT id FROM ".$TBL['mes_rec']."  where dest=".$idu." and groupe=".$idg." and lu=0";
			$db->query($sSQL)	;
			$ret['nb2'] = $db->num_rows()	;
		} else {
			// emission
			$sSQL = "SELECT id FROM ".$TBL['mes_send']."  where source=".$idu." and groupe = ".$idg ;
			$db->query($sSQL)	;
			$ret['nb'] = $db->num_rows()	;
			$sSQL = "SELECT id FROM ".$TBL['mes_send']."  where source=".$idu." and groupe=".$idg." and lu=0";
			$db->query($sSQL)	;
			$ret['nb2'] = $db->num_rows()	;
		}
		return($ret);
	}

	/**
	* Retourne le nombre de messages envoye
	* @param	integer	$idu ID du membre source
	* @param	integer	$idg Id du groupe
	* @return	integer Retourne le nombre de messages envoye
	* @access	public
	*/
	function NbSend($idu,$idg) {
	 global $TBL, $db;
		$sSQL = "SELECT id FROM ".$TBL['mes_send']."  where source=".$idu." and groupe= ".$idg ;
		$db->query($sSQL)	;
		return($db->num_rows())	;
	}

	/**
	* retourne le nombre de messages recu 
	* @param	integer	$idu ID du membre destinataire
	* @param	integer	$idg Id du groupe
	* @return	integer Retourne le nombre de messages recu
	* @access	public
	*/
	function NbRec($idu,$idg) {
	 global $TBL, $db;
		$sSQL = "SELECT id FROM ".$TBL['mes_rec']."  where dest=".$idu." and groupe=".$idg ;
		$db->query($sSQL)	;
		return($db->num_rows())	;
	}

	/**
	* Retourne le nombre de messages recu et non lu
	* @param	integer	$idu ID du membre destinataire
	* @param	integer	$idg Id du groupe
	* @return	integer Retourne le nombre de messages recu et non lu
	* @access	public
	*/
	function NbRecNotRead($idu,$idg) {
	 global $TBL, $db;
		$sSQL = "SELECT id FROM ".$TBL['mes_rec']." where dest=".$idu." and lu=0 and groupe=".$idg ;
		$db->query($sSQL)	;
		return($db->num_rows())	;
	}

	/**
	* Supprime le fichier attache si son compteur est arrive a 0
	* @param	integer	$nb   compteur du fichier
	* @param	integer	$file nom du fichier
	* @param	integer	$idm  Id du message
	* @access	private
	*/
	function DeleteFile($nb,$file,$idm) {
	 global $TBL, $ClsGroupe, $groupe, $db ;
		if ( $nb > 0 ) {
			if ( --$nb > 0 ) {
				$sSQL = "UPDATE ".$TBL['mes_doc']." SET compteur=".$nb." WHERE id=".$idm ;
				$db->query($sSQL) ;
			}
		}
		if ( $nb <= 0 ) {
			$rep = $ClsGroupe->Directory($groupe) ;
			$fichier =  RP_GROUPES.$rep."/messages/".$file	;
			unlink($fichier)			;
			$sSQL = "DELETE FROM ".$TBL['mes_doc']." where id=".$idm		;
			$db->query($sSQL) ;
		}
	}

	/**
	* Supprime le message
	* @param	integer	$idm  Id du message
	* @access	public
	*/
	function DeleteWebMail($idm) {
	 global $TBL, $cmd_wm, $ClsGroupe, $guserid, $groupe, $db ;
		// 0 -> Reception
		// gestion des documents attaches
		$table = ($cmd_wm==CMD_WM_INBOX?$TBL['mes_rec']:$TBL['mes_send']) ;
		$sSQL = "SELECT d.id, d.compteur, d.fichier FROM ".$TBL['mes_doc']." d, ".$table." m " ;
		$sSQL.= "where m.id=".$idm." and d.fichier=m.fichier " ;
		$db->query($sSQL) ;
		if ( $db->num_rows() > 0 ) {
			$db->next_record() ;
			$this->DeleteFile($db->f("compteur"),$db->f("fichier"),$db->f("id")) ;
		}
		// envoyer un AR
		$sSQL = "SELECT source,text,ar FROM ".$table." WHERE id=".$idm ;
		$db->query($sSQL) ;
		$db->next_record() ;
		if ( $db->f("ar") == 1 && $guserid != $db->f("source") ) {
			$this->SendAR($db->f("source"),$db->f("text"));
		}
		// supprimer le message
		$sSQL = "DELETE FROM ".$table." where id=".$idm  ;
		$db->query($sSQL) ;
	}

	/**
	* Supprime tous les messages d'un groupe
	* @param	integer	$idg  Id du groupe
	* @access	public
	*/
	function DeleteGroupe($idg) {
	 global $TBL, $db;
		$sSQL = "DELETE FROM ".$TBL['mes_rec']." where groupe=".$idg;
		$db->query($sSQL) ;
		$sSQL = "DELETE FROM ".$TBL['mes_send']." where groupe=".$idg;
		$db->query($sSQL) ;
		$sSQL = "SELECT id FROM ".$TBL['membres']." WHERE id_groupe=".$idg;
		$db->query($sSQL) ;
		while( $db->next_record() ) {
			$sSQL = "DELETE FROM ".$TBL['mes_doc']." where id=".$idg;
			$this->_db->query($sSQL) ;
		}
	}

	/**
	* Marque un message comme lu et envoie un accuse de reception
	* @param	integer	$idm  Id du groupe
	* @access	public
	*/
	function ReadWebMail($idm) {
	 global $TBL, $guserid, $guser, $ClsMembre, $db ;
		$sSQL = "SELECT lu,source,text,ar FROM ".$TBL['mes_rec']." where id=".$idm  ;
		$db->query($sSQL)	;
		if ( $db->next_record()	) {
			if ( $db->f("lu") != 1 ) {
				$sSQL = "update ".$TBL['mes_rec']." set lu=1, ar=0 where id=".$idm  ;
				$db->query($sSQL)	;
				// Envoyer un message AR
				if ( $db->f("ar") == 1 ) {
					$this->SendAR($db->f("source"),$db->f("text"));
				}
			}
		}
	}

	/**
	* Lecture d'un message
	* @param	integer	$id  Id du message
	* @access	public
	*/
	function ReadMessage($id) {
		global $db, $TBL ;
		$sSQL = "SELECT u.id,u.prenom,u.nom,m.objet,m.text,m.date ";
		$sSQL.= "FROM ".$TBL['mes_rec']." m, ".$TBL['membres']." u " ;
		$sSQL.= "WHERE m.source=u.id and m.id=".$id;
		$db->query($sSQL)	;
		$ret = array() ;
		if ( $db->next_record()	) {
			$ret['source']	= $db->f(1).' '.$db->f(2)	;
			$ret['objet']	= Unreplace($db->f(3))	;		
			$ret['text']	= Unreplace($db->f(4))	;			
			$ret['date']	= $db->f(5)	;					
		}
		return($ret);
	}
		
 } // class WebMail 

/**
* Instance de la classe WebMail
* @var	object	WebMail
*/
$ClsWebMail = new WebMail ;

?>